

#define ARITHTYPE float
#define ARITHDISTANCE distance
#define FLOAT_ARITHMETIC 1
#define ARITHTOLERANCE m_Tolerance


#ifndef DT_H
#define DT_H

#include "stdafx.h"
#include "coord.h"

#include <vector>
#include <string>
using std::vector;
using std::string;


class TDt
{
public:
	TDt();
	static const float INFINITY;
	void getNeighbors(const TCoord2 & p, int s, vector<TCoord2> & N);
	enum DT_TYPE
	{
		DT_FMM, DT_FCDT, DT_MCDT, DT_ECDT, DT_GCDT, DT_EXACT
	};

	virtual DT_TYPE getDtType() const  = 0;
	virtual int getNeighborCount() const  = 0;
	virtual float getTolerance() const  = 0;

	virtual void stageInit() = 0;
	virtual void stageMain() = 0;
	virtual void stageEnd() = 0;
	void perform() { stageInit(); stageMain(); stageEnd(); }

	virtual shared_ptr<class TFloatField3> getDistance() const  = 0;
	virtual shared_ptr<class TOrigSetField2> getOrigins() const  = 0;
	virtual string getLatexName() const = 0;
	virtual string getShortName() const = 0;

	float getTime() { return m_Time; }

//	float m_Tolerance;
//	int m_NeighborCount;
	float m_Time;
	bool m_AlreadyPerformed;
};	

class TDtComparison
{
public:
	TDtComparison(shared_ptr<TDt> p_Dt1,shared_ptr<TDt> p_Dt2, bool p_StoreResult);
	string convertDistancesToLatex();

	shared_ptr<TDt> m_Dt1;
	shared_ptr<TDt> m_Dt2;
	TDt::DT_TYPE m_DtType;
	float m_Tolerance;
	int m_NeighborCount;
	string m_LatexName;
	string m_ShortName;
	float m_Time;
	string toText();
	void writeToStream(std::ofstream & p_Stream);
	TDtComparison * readFromStream(std::ifstream & p_Stream);

	shared_ptr<TFloatField3> m_DistanceDiff;
	shared_ptr<TFloatField3> m_OriginsDiff;

	int m_ObjectPixelCount;
	float m_DistErrorCount, m_DistPercError, m_DistMaxError, m_DistMinError, m_DistAvgError;
	float m_OrigErrorCount, m_OrigPercError, m_OrigMaxError, m_OrigMinError, m_OrigAvgError;
	float m_RelOrigMaxError, m_RelOrigAvgError;
protected:
	TDtComparison() {};
};

class TDtProcessor
{
public:
	void performComparison(const string p_Caption, const TFloatField3 * p_Image, bool p_AddLayer, vector<shared_ptr<TDtComparison> > & p_Comparisons, vector<float> & p_Tolerances, bool p_DoAll);
	void processComparisons(vector<shared_ptr<TDtComparison> > & Comparisons, vector<float> & Tolerances);
	
};


#endif
