#include "edt.h"


/*

Dit is een kopie van cdt2.cpp, met daarin m_FmmDistance weggehaald.

*/

#include "field.h"


void TEdt::stageInit()
{
	m_Distance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );

	// Fields needed for FMM algorithm
	m_FlagField.reset( TFlagField3::constructFrom2DFloatField(m_Image, m_Distance.get(), 0) );
	//m_OrigsIndexed = new FIELD<std::multimap<float,int> >(m_FlagField->getMaxX(), m_FlagField->getMaxY() );
	m_Origins.reset( new TOrigSetField2( m_Image->getMaxX(), m_Image->getMaxY()) );
	m_Pointers = new FIELD<TNarrowBand::iterator>(m_FlagField->getMaxX(), m_FlagField->getMaxY() );

	m_Tolerance2 = (int)(m_Tolerance*m_Tolerance+0.5f); 
}

void TEdt::stageMain()
{
	// Fill m_From & m_OrigsIndexed
	vector<TCoord2> N; N.reserve(8);
	{
		for(int i=0; i<m_FlagField->getMaxX(); i++)
		{
			for(int j=0; j<m_FlagField->getMaxY(); j++)
			{
				if(m_FlagField->narrowband(i,j))
				{
					m_Distance->value(i,j) = 0;
					m_Pointers->value(i,j) = V.insert( 
						TNarrowBand::value_type(m_Distance->value(i,j), TCoord2(i,j)) 
						);

					TOrigSet2 & os = m_Origins->value(i,j);
					os.insert( TOrigSet2::value_type(0, TCoord2(i,j)) );

					const TCoord2 c(i,j); 
					N.clear();
					getNeighbors(c, m_NeighborCount, N);
					for(int k=0; k<N.size(); k++)
					{
						const TCoord2 & n = N[k];;
						if( ! m_FlagField->narrowband(n.x,n.y) ) continue;
						const ARITHTYPE d = c.ARITHDISTANCE(n);
						if(d>ARITHTOLERANCE) continue;
						os.insert( TOrigSet2::value_type(d, n) );		
					}
				}
				else if(m_FlagField->unknown(i,j))
				{
					m_Distance->value(i,j) = INFINITY;
				}
				else if(m_FlagField->known(i,j))
				{
					m_Distance->value(i,j) = -1;
				}
			}
		}
	}

	// Do iteration
	TCoord2 a;
	TOrigSet2::const_iterator it,jt;
	TOrigSet2::iterator kt;
	TOrigSet2 NewOrigins;
	vector<TCoord2> Na; Na.reserve(8);
	vector<TCoord2> Np; Np.reserve(8);
//	TOrigSet2 C;

	// Debug
	ofstream str("_etft.txt");
	int iter = 0;

	// Perform 
	while(V.size() != 0)
	{
		// Debug
		iter++;
		str << iter << ": ";		;
		for(TNarrowBand::iterator vt = V.begin(); vt != V.end(); vt++)
		{
			TCoord2 c = vt->second;
			str << c.x << "," << c.y << " ";
		}
		str << "\n";
		

		// Let p = argmin_q D(q)
		const TCoord2 p = V.begin()->second;
		m_FlagField->value(p.x,p.y) = TFlagField3::KNOWN;
		V.erase(V.begin());

		getNeighbors(p, 4, Np);
		for(int k=0; k<Np.size(); k++)
		{
			const TCoord2 & a = Np[k];
			if( m_FlagField->known(a.x,a.y)) continue; // for each a \in N^{U,T}(p)

			// Construct conservative set C 
			TOrigSet2 & C = m_Origins->value(a.x, a.y);
			{

				//C.clear();
				getNeighbors(a, m_NeighborCount, Na);
				Na.push_back(a);
				for(int j=0; j<Na.size(); j++)
				{
					const TCoord2 & b = Na[j];
					if( m_FlagField->unknown(b.x,b.y)  ) continue; // for each b \in N^{T,K}(a)

					// Debug
					if(a.x == 35 && a.y == 3)
					{
						int test = 5;
					}

					// Insert S(b) into C
					{
						const TOrigSet2 & Sb = m_Origins->value(b.x,b.y);
						for(it = Sb.begin(); it != Sb.end(); it++)
						{
							// Find out if 'it' occurs in C (smarter than 1)
							const ARITHTYPE d = a.ARITHDISTANCE(it->second);
							bool found = false;
							for(kt = C.lower_bound(d); kt != C.end(); kt++)
							{
								if(kt->first > d) break;
								if(kt->second == it->second) { found = true; break; }
							}
							if(!found) C.insert( TOrigSet2::value_type(d, it->second) );
						}
					}
				}
			}
 
			// Prune C: remove all origins at larger distance than d_min + threshold
			const ARITHTYPE d_min = C.begin()->first;
#ifdef FLOAT_ARITHMETIC
			kt = C.upper_bound(d_min + m_Tolerance);
#else
			const float d_min_root = sqrtf(d_min);
			kt = C.upper_bound(d_min + 2*m_Tolerance*d_min_root + m_Tolerance2);
#endif
			C.erase(kt,C.end());
			//m_Origins->value(a.x,a.y) = C;
			
	

			// Add 'a' to narrowband
			if( m_FlagField->unknown(a.x,a.y) ) 
			{
				m_FlagField->value(a.x,a.y) = TFlagField3::NARROW_BAND;
				m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(d_min, a) );
			}
			else if( m_FlagField->narrowband(a.x,a.y) )
			{
				V.erase( m_Pointers->value(a.x,a.y) );
				m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(d_min, a) );
			}
		}
	} // end while


	// Debug
	str.close();

}

void TEdt::stageEnd()
{
	// Create CDT distances and origin fields
	m_Distance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );
	for(int i=0;i<m_Origins->dimX();i++)
	{
		for(int j=0;j<m_Origins->dimY();j++)
		{
			m_Distance->value(i,j) = (m_Origins->value(i,j).size())? m_Origins->value(i,j).begin()->second.distance(TCoord2(i,j)) : -1; 
		}
	}

	// delete m_OrigsIndexed;
	delete m_Pointers;
}




string TEdt::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }

	string r = wxString::Format("\\ecdt{}|%i $\\epsilon%s$", m_NeighborCount, sTolerance.c_str());
	return r;
}



string TEdt::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("ECDT|%i e%s", m_NeighborCount, sTolerance.c_str());
	return r;
}


void TEdt::deleteFields()
{
	//m_FlagField.reset();
	//m_FmmDistance.reset();
	//m_CdtDistance.reset();
	//m_Origins.reset();
}















