#include "edt2.h"

#include "field.h"

/*

	 Contains several Edt variants, specified by 'int Method'.

*/


void TEdt2::stageInit()			                        
{								
	m_Distance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );
	m_FlagField.reset( TFlagField3::constructFrom2DFloatField(m_Image, m_Distance.get(), 0) );
	m_Origins.reset( new TOrigSetField2(m_FlagField->dimX(),m_FlagField->dimY()) );
	m_Pointers = new FIELD<TNarrowBand::iterator>(m_FlagField->getMaxX(), m_FlagField->getMaxY());

	m_Tolerance2 = (int)(m_Tolerance*m_Tolerance+0.5f); 
}

void TEdt2::stageMain()
{
	// Set origins of narrowband points & fill narrowband
	V.clear();
	vector<TCoord2> N; 
	N.resize(8);

	for(int i=0; i<m_FlagField->getMaxX(); i++)									
	{
		for(int j=0; j<m_FlagField->getMaxY(); j++)
		{
			if (m_FlagField->narrowband(i,j))					//For the boundary points:
			{	
				 // initialisatie os
				TOrigSet2 & os = m_Origins->value(i,j);
				const TCoord2 c(i,j); 

				os.erase(os.begin(),os.end());
				os.insert( TOrigSet2::value_type(0,c) ); // Insert point itself
				m_Pointers->value(i,j) = V.insert( TNarrowBand::value_type(0,c) );

				N.clear();
				getNeighbors(c, m_NeighborCount, N);
				for(int k=0; k<N.size(); k++)
				{
					const TCoord2 & n = N[k];;
					if( ! m_FlagField->narrowband(n.x,n.y) ) continue;
					const ARITHTYPE d = c.ARITHDISTANCE(n);
					if(d>ARITHTOLERANCE) continue;
					os.insert( TOrigSet2::value_type(d, n) );		
				}

			}
		}
	}
		
	// Do iteration
	TCoord2 a;
	TOrigSet2::const_iterator it,jt;
	TOrigSet2::iterator kt;
	TOrigSet2 NewOrigins;
	vector<TCoord2> Np; Np.reserve(8);
	vector<TCoord2> Na; Na.reserve(8);
//	TOrigSet2 C;

	const int Method = 0; // change Edt variant here

	while(V.size() != 0)
	{
		// Let p = argmin_q D(q)
		const TCoord2 p = V.begin()->second;
		m_FlagField->value(p.x,p.y) = TFlagField3::KNOWN;
		V.erase(V.begin());

		getNeighbors(p, 4, Np);
		for(int i=0; i<Np.size(); i++)
		{
			const TCoord2 & a = Np[i];
			//if(!m_FlagField->unknown(a.x,a.y)) continue; // for each a \in N^U(p)
			if(m_FlagField->known(a.x,a.y)) continue; // for each a \in N^{U,T}(p)

			TOrigSet2 & C = m_Origins->value(a.x, a.y);

			// Construct conservative set C 
			{
				//C.clear();
				getNeighbors(a, m_NeighborCount, Na);

				for(int j=0; j<Na.size(); j++)
				{
					const TCoord2 & b = Na[j];
					// if( ! m_FlagField->narrowband(b.x,b.y)  ) continue; // for each b \in N^{T}(a)
					if( m_FlagField->unknown(b.x,b.y)  ) continue; // for each b \in N^{T,K}(a)

					// Insert S(b) into C
					{
						const TOrigSet2 & Sb = m_Origins->value(b.x,b.y);
						for(it = Sb.begin(); it != Sb.end(); it++)
						{
							// Original 
							if(Method == 0) 
							{
								// Find out if 'it' occurs in C by linear search (slow)
								for(jt = C.begin(); jt != C.end(); jt++) 
									if(it->second == jt->second) break;								

								if(jt == C.end()) C.insert( TOrigSet2::value_type(a.ARITHDISTANCE(it->second),it->second) );
							}
							else if(Method == 1)
							{
								// Debug: verwijder geen duplicates
								C.insert( TOrigSet2::value_type(a.ARITHDISTANCE(it->second),it->second) );
							}
							else if(Method == 2)
							{	
								// Find out if 'it' occurs in C (smarter than 1)
								const ARITHTYPE d = a.ARITHDISTANCE(it->second);
								bool found = false;
								for(kt = C.lower_bound(d); kt != C.end(); kt++)
								{
									if(kt->first > d) break;
									if(kt->second == it->second) { found = true; break; }
								}
								if(!found) C.insert( TOrigSet2::value_type(d, it->second) );
							}
						}
					}
				}
			}
 
			// Original 
			ARITHTYPE d_min;
			if(Method == 0)
			{
				//m_Origins->value(a.x,a.y).clear();

				d_min = C.begin()->first;
#ifdef FLOAT_ARITHMETIC
				kt = C.upper_bound(d_min + m_Tolerance);
#else
				const float d_min_root = sqrtf(d_min);
				kt = C.upper_bound(d_min + 2*m_Tolerance*d_min_root + m_Tolerance2);
#endif
				C.erase(kt,C.end());


				/*
				// Remove all q \in C : |q-a| > d_min + m_Tolerance
				d_min = C.begin()->first;
				for(kt = C.begin(); kt != C.end(); kt++)
				{
					const ARITHTYPE d = kt->first;
#ifdef FLOAT_ARITHMETIC
					if(d <= d_min + m_Tolerance)
#else
					const int t = d - d_min - m_Tolerance2;
					const long t2 = t*t*(t>0 ? 1 : -1);
					if(t2 <= 4*m_Tolerance2*d_min) // warning, t*t can overflow, but this will not happen in practice 
#endif
					{
						m_Origins->value(a.x,a.y).insert( *kt );		
					}
				}
				*/
			}
			else if(Method == 1)
			{
				throw string("Not implemented");
/*
				// C invoegen in Sa. Duplicates niet toevoegen. Dit zou sneller moeten gaan dan wanneer dit hierboven wordt gechecked.
				d_min = C.begin()->first;
				const float limit = d_min + m_Tolerance;
				TOrigSet2 & Sa = m_Origins->value(a.x,a.y);
				Sa.clear();
				for(kt = C.begin(); kt != C.end(); kt++)
				{
					// Exit if tolerance reached
					if(kt->first > limit)  break;

					// See if kt already occurs in Sa
					bool found = false;
					for(it = Sa.begin(); it != Sa.end(); it++)
					{
						if(it->second == kt->second) { found = true; break; }
						if(it->first > limit) break; 
					}
					if(!found) Sa.insert( *kt );
				}
			*/
			}
			else if(Method == 2)
			{
		/*
				const ARITHTYPE d_min = C.begin()->first;
#ifdef FLOAT_ARITHMETIC
				kt = C.upper_bound(d_min + m_Tolerance);
#else
				const float d_min_root = sqrtf(d_min);
				kt = C.upper_bound(d_min + 2*m_Tolerance*d_min_root + m_Tolerance2);
#endif
				C.erase(kt,C.end());
				m_Origins->value(a.x,a.y) = C;
				*/
			}


			// Add 'a' to narrowband
			if( m_FlagField->unknown(a.x,a.y) ) 
			{
				m_FlagField->value(a.x,a.y) = TFlagField3::NARROW_BAND;
				m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(d_min,a) );
			}
			else if( m_FlagField->narrowband(a.x,a.y) )
			{
				V.erase( m_Pointers->value(a.x,a.y) );
				m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(d_min,a) );
			} 
		}
	} // end while

	m_AlreadyPerformed = true;
}

void TEdt2::stageEnd()
{
	// Fill m_Distance
	{
		for(int i=0;i<m_Distance->dimX();i++)
			for(int j=0;j<m_Distance->dimY();j++)
			{
				if(m_Origins->value(i,j).size() > 0)
				{
					m_Distance->value(i,j) = (m_Origins->value(i,j).size())? m_Origins->value(i,j).begin()->second.distance(TCoord2(i,j)) : 0; 
				}
				else
				{
					m_Distance->value(i,j) = -1;
				}
			}
	}

}


string TEdt2::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }

	return wxString::Format("\\ecdt{}2|%i $\\epsilon%s$", m_NeighborCount, sTolerance.c_str());
}

string TEdt2::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("ECDT2|%i e%s", m_NeighborCount, sTolerance.c_str());
	return r;
}


void TEdt2::deleteFields()
{
	//m_FlagField.reset();
	//m_Distance.reset();
	//m_Origins.reset();
}


