#include "edt3.h"

#include "field.h"


void TEdt3::stageInit()			                        
{								
	m_Distance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );
	m_FlagField.reset( TFlagField3::construct(m_Image, m_Distance.get(), 0) );
	m_Origins.reset( new TOrigSetField2(m_FlagField->dimX(),m_FlagField->dimY()) );
	m_Pointers = new FIELD<TNarrowBand::iterator>(m_FlagField->getMaxX(), m_FlagField->getMaxY() );

	m_Tolerance2 = (int)(m_Tolerance*m_Tolerance+0.5f); 
}

void TEdt3::stageMain()
{
	// Set origins of narrowband points & fill narrowband
	V.clear();
	vector<TCoord2> N; 
	N.resize(8);

	for(int i=0; i<m_FlagField->getMaxX(); i++)									
	{
		for(int j=0; j<m_FlagField->getMaxY(); j++)
		{
			if (m_FlagField->narrowband(i,j))					//For the boundary points:
			{	
				// Update m_Origins->value(i,j)
				TOrigSet2 & os = m_Origins->value(i,j);
				const TCoord2 c(i,j); 

				os.erase(os.begin(),os.end());
				os.insert( TOrigSet2::value_type(0,c) ); // Insert point itself
				m_Pointers->value(i,j) = V.insert( TNarrowBand::value_type(0,c) );

				N.clear();
				getNeighbors(c, m_NeighborCount, N);
				for(int k=0; k<N.size(); k++)
				{
					const TCoord2 & n = N[k];
					if( ! m_FlagField->narrowband(n.x,n.y) ) continue;
					const ARITHTYPE d = c.ARITHDISTANCE(n);
					if( d > ARITHTOLERANCE ) continue;
					os.insert( TOrigSet2::value_type(d, n) );		
				}

			}
		}
	}
		
	TCoord2 a;
	TOrigSet2::const_iterator it,jt;
	TOrigSet2::iterator kt;
	vector<TCoord2> Np; Np.reserve(8);
	vector<TCoord2> Na; Na.reserve(8);
	TOrigSet2 C;


	// Propagate
	while(V.size() != 0)
	{
		// Todo
		
		// Uncomment this to alter the order in which the points in the narrowband 
		// datastructure are stored. One would think this has no effect, but it does.
		// In this way, points are not propagated in a natural order, namely in the order
		// in which points lie next to each other. This results in errors on different places 
		// in the image.
		
			const float test1 = V.begin()->first;
			const TCoord2 test2 = V.begin()->second;
			V.erase(V.begin());
			V.insert( TNarrowBand::value_type(test1,test2) );
		
		

		// Let p = argmin_q D(q)
		const TCoord2 p = V.begin()->second;
		m_FlagField->value(p.x,p.y) = TFlagField3::KNOWN;
		V.erase(V.begin());


		getNeighbors(p, 4, Np);
		for(int i=0; i<Np.size(); i++)
		{
			const TCoord2 & a = Np[i];
			if( ! m_FlagField->unknown(a.x,a.y)) continue; // for each a \in N^U(p)
			//if(m_FlagField->known(a.x,a.y)) continue; // for each a \in N^{U,T}(p)

			getNeighbors(a, m_NeighborCount, Na);
			Na.push_back(a);

			// Determine d_min
			ARITHTYPE d_min = (numeric_limits<ARITHTYPE>::max)();
			for(int j=0; j<Na.size(); j++)
			{
				const TCoord2 & b = Na[j];
				if( m_FlagField->unknown(b.x,b.y)  ) continue; // for each b \in N^{T,K}(a)
				const TOrigSet2 & Sb = m_Origins->value(b.x,b.y);

				const ARITHTYPE d = a.ARITHDISTANCE( Sb.begin()->second );
				if( d < d_min )
				{
					d_min = d;
				}
			}

			// Construct C
			TOrigSet2 & C = m_Origins->value(a.x,a.y);
			for(j=0; j<Na.size(); j++)
			{
				const TCoord2 & b = Na[j];
				if( m_FlagField->unknown(b.x,b.y)  ) continue; // for each b \in N^{T,K}(a)



				const TOrigSet2 & Sb = m_Origins->value(b.x,b.y);
				for(it = Sb.begin(); it != Sb.end(); it++)
				{
					const TCoord2 & borg = it->second;
					const ARITHTYPE d = a.ARITHDISTANCE( borg ); 

#ifdef FLOAT_ARITHMETIC
					if(d <= d_min + m_Tolerance)
#else
					const int t = d - d_min - m_Tolerance2;
					if(t > 2 * d_min * m_Tolerance2) continue; // prevent overflow by bailing out early 
					if(t*t <= 4*m_Tolerance2*d_min) 
#endif
					{
						// Find out if 'it' occurs in C
						bool found = false;
						for(kt = C.lower_bound(d); kt != C.end(); kt++)
						{
							if(kt->first > d) break;
							if(kt->second == it->second) { found = true; break; }
						}
						if(!found) C.insert( TOrigSet2::value_type(d, it->second) );
					}
					else break; // more correct without break but slower
				}
			}

			// Add 'a' to narrowband
			if( m_FlagField->unknown(a.x,a.y) ) 
			{
				m_FlagField->value(a.x,a.y) = TFlagField3::NARROW_BAND;
				m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(d_min,a) );
			}
			else if( m_FlagField->narrowband(a.x,a.y) )
			{
				V.erase( m_Pointers->value(a.x,a.y) );
				m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(d_min,a) );
			} 

		}
	} // end while

	m_AlreadyPerformed = true;
}

void TEdt3::stageEnd()
{
	// Fill m_Distance
	{
		for(int i=0;i<m_Distance->dimX();i++)
			for(int j=0;j<m_Distance->dimY();j++)
			{
				if(m_Origins->value(i,j).size() > 0)
				{
					m_Distance->value(i,j) = (m_Origins->value(i,j).size())? m_Origins->value(i,j).begin()->second.distance(TCoord2(i,j)) : 0; 
				}
				else
				{
					m_Distance->value(i,j) = -1;
				}
			}
	}

	delete m_Pointers;
}



string TEdt3::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }

	return wxString::Format("\\ecdt{}%i $\\epsilon%s$", m_NeighborCount, sTolerance.c_str());
}

string TEdt3::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("ETFT%i e%s", m_NeighborCount, sTolerance.c_str());
	return r;
}


void TEdt3::deleteFields()
{
	//m_FlagField.reset();
	//m_Distance.reset();
	//m_Origins.reset();
}


