#include "exactdt.h"


#include "field.h"


void TExactDt::stageInit()			                        
{								
	m_Distance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );
	m_FlagField.reset( TFlagField3::construct(m_Image, m_Distance.get(), 0) );
	m_Origins.reset( new TOrigSetField2(m_FlagField->dimX(),m_FlagField->dimY()) );
}


void TExactDt::stageMain()
{
	if(m_AlreadyPerformed) throw string("Edt already performed"); 

	m_Tolerance2 = (int)(m_Tolerance*m_Tolerance+0.5f); 


	// Make a set of boundary voxels
	vector<TCoord2> Boundary;
	{
		for(int i=0; i<m_FlagField->getMaxX(); i++)
		{
			for(int j=0; j<m_FlagField->getMaxY(); j++)
			{
				if(m_FlagField->narrowband(i,j) ) Boundary.push_back( TCoord2(i,j) );
			}
		}
	}

    for(int i=0;i<m_FlagField->dimX();i++)
	{
		for(int j=0;j<m_FlagField->dimY();j++)
		{
			TCoord2 c(i,j);

			if (! m_FlagField->outside(i,j) ) // only assign to inside or boundary points 
			{
				// Find minimum distance boundary point
				ARITHTYPE d_min = (numeric_limits<ARITHTYPE>::max)();
				TCoord2 p_min(0,0);
				{
					for(int b=0;b<Boundary.size();b++)
					{
						const TCoord2 & p = Boundary[b];
						const ARITHTYPE d = c.ARITHDISTANCE(p);
						if (d < d_min) 
						{
							d_min = d;
							p_min = p;
						}
					}
				}

				m_Distance->value(i,j) = p_min.distance(c);

				// Now put all points at minimum distance (+threshold) in origset
				{
					for(int b=0;b<Boundary.size();b++)
					{
						const TCoord2& p = Boundary[b];
						const ARITHTYPE d = c.ARITHDISTANCE(p);

#ifdef FLOAT_ARITHMETIC 
						if(d <= d_min + m_Tolerance)
#else
						const long t = d - d_min - m_Tolerance2;
						if(t > 2 * d_min * m_Tolerance2) continue; // prevent overflow by bailing out early 
						const long t2 = t*t*(t>0 ? 1 : -1); // t may be negative
						const long compare = 4*m_Tolerance2*d_min;
						if(t2 <= compare) 
#endif
						{
							m_Origins->value(i,j).insert( TOrigSet2::value_type(d,p) );
						}
					 }
				 }
			}
			else 
			{
				// origset->value(i,j) remains empty
				m_Distance->value(i,j) = -1;
			}
		}
	}

	m_AlreadyPerformed = true;
}


void TExactDt::stageEnd()
{
}



string TExactDt::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }

	return wxString::Format("Exact $\\epsilon%s$", sTolerance.c_str());
}

string TExactDt::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("Exact e%s", sTolerance.c_str());
	return r;
}

void TExactDt::deleteFields()
{
	//m_FlagField.reset();
	//m_Distance.reset();
	//m_Origins.reset();
}
