#ifndef EXACTDT_H
#define EXACTDT_H

#include "dt.h"

class TExactDt : public TDt
{
public:
	TExactDt(const TFloatField3 * p_Image, float p_Tolerance) 
		: TDt()
		, m_Image(p_Image)
		, m_Tolerance(p_Tolerance) 
	{
	}

	virtual DT_TYPE getDtType() const { return DT_EXACT; }
	virtual int getNeighborCount() const { return 0; }
	virtual float getTolerance() const { return m_Tolerance; }

	virtual void stageInit();
	virtual void stageMain();
	virtual void stageEnd();
	virtual string getLatexName() const;
	virtual string getShortName() const;

	virtual shared_ptr<TFloatField3> getDistance() const { return m_Distance; };
	virtual shared_ptr<TOrigSetField2> getOrigins() const { return m_Origins; }
	virtual void deleteFields();

protected:
	float m_Tolerance;
	int m_Tolerance2;
	const class TFloatField3 * m_Image;
	shared_ptr<class TFloatField3> m_Distance;
	shared_ptr<class TOrigSetField2> m_Origins;
	shared_ptr<class TFlagField3> m_FlagField;

};

#endif
