#include "exactdt3.h"


#include "field.h"
#include "indexedoriginsfield.h"


void TExactDt3::stageInit()			                        
{								
	m_Distance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );
	m_FlagField.reset( TFlagField3::constructFrom2DFloatField(m_Image, m_Distance.get(), 0) );
	//m_FlagField.reset( TFlagField3::construct(m_Image, m_Distance.get(), 0) );
	m_Boundary.reset( new TBoundary(m_FlagField.get()) );
	m_BoundaryPixelToObjectPixels.reset( new TCoord3SetSortedField(m_FlagField->dimX(),m_FlagField->dimY(),m_FlagField->dimZ()) );
}




void TExactDt3::stageMain()
{
/*
	m_IndexedOrigins.reset( new TIndexedOriginsField(*m_Boundary.get(), m_FlagField->dimX(),m_FlagField->dimY(),m_FlagField->dimZ()) );
	m_Tolerance2 = (int)(m_Tolerance*m_Tolerance+0.5f); 
	

    for(int i=0;i<m_FlagField->dimX();i++)
	{
		for(int j=0;j<m_FlagField->dimY();j++)
		{
			for(int k=0;k<m_FlagField->dimZ();k++)
			{

				TCoord3 c(i,j,k);

				if (m_FlagField->value(i,j,k) != 1) // only assign to inside or boundary points 
				{
					// Find minimum distance boundary point
					ARITHTYPE d_min = (numeric_limits<ARITHTYPE>::max)();
					TCoord3 p_min(0,0,0);
					{
						for(int b=0;b<m_Boundary->size();b++)
						{
							const TCoord3 & p = (*m_Boundary)[b];
							const ARITHTYPE d = c.ARITHDISTANCE(p);
							if (d < d_min) 
							{
								d_min = d;
								p_min = p;
							}
						}
					}

					m_Distance->value(i,j,k) = p_min.distance(c);

					// Now put all points at minimum distance (+threshold) in origset
					{
						for(int b=0;b<m_Boundary->size();b++)
						{
							const TCoord3& p = (*m_Boundary)[b];
							const ARITHTYPE d = c.ARITHDISTANCE(p);

	#ifdef FLOAT_ARITHMETIC 
							if(d <= d_min + m_Tolerance)
	#else
							const long t = d - d_min - m_Tolerance2;
							if(t > 2 * d_min * m_Tolerance2) continue; // prevent overflow by bailing out early 
							const long t2 = t*t*(t>0 ? 1 : -1); // t may be negative
							const long compare = 4*m_Tolerance2*d_min;
							if(t2 <= compare) 
	#endif
							{
								m_IndexedOrigins->value(i,j,k)->add( b );
								m_BoundaryPixelToObjectPixels->value(p.x,p.y,p.z).insert( TCoord3SetSorted::value_type(0,TCoord3(i,j,k)) );
							}
						 }
					 }
				}
				else 
				{
					// origset->value(i,j) remains empty
					m_Distance->value(i,j) = -1;
				}
			}
		}
	}
*/
}


void TExactDt3::stageEnd()
{
}


void TExactDt3::removeSpuriousBoundaryPoints()
{
	throw string("Not implemented");
	/*
    for(int i=0;i<m_FlagField->dimX();i++)
	{
		for(int j=0;j<m_FlagField->dimY();j++)
		{
			for(int k=0;k<m_FlagField->dimZ();k++)
			{
				const TCoord3 b(i,j,k);
				if(m_FlagField->value(i,j,k) == 0 && m_BoundaryPixelToObjectPixels->value(i,j,k).size() == 1)
				{
					m_FlagField->value(i,j,k) = 1;
					const TCoord3SetSorted opixels = m_BoundaryPixelToObjectPixels->value(i,j,k);
					TCoord3SetSorted::const_iterator it;
					for(it = opixels.begin(); it != opixels.end(); it++)
					{
						const TCoord3 p = it->second;
						m_IndexedOrigins->value(p.x,p.y,p.z).erase( m_IndexedOrigins->value(p.x,p.y,p.z).find(m_Boundary->reverseLookup(b)) );
					}
				}
			}
		}
	}
	m_Boundary.reset( new TBoundary(m_FlagField.get()) );

	stageMain();
	*/
}



string TExactDt3::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }

	return wxString::Format("Exact $\\epsilon%s$", sTolerance.c_str());
}

string TExactDt3::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("Exact e%s", sTolerance.c_str());
	return r;
}

void TExactDt3::deleteFields()
{
	//m_FlagField.reset();
	//m_Distance.reset();
	//m_Origins.reset();
}
