#ifndef EXACTDT3_H
#define EXACTDT3_H

#include "dt.h"

class TExactDt3 : public TDt
{
public:
	TExactDt3(const TFloatField3 * p_Image, float p_Tolerance) 
		: TDt()
		, m_Image(p_Image)
		, m_Tolerance(p_Tolerance) 
	{
	}

	virtual DT_TYPE getDtType() const { return DT_EXACT; }
	virtual int getNeighborCount() const { return 0; }
	virtual float getTolerance() const { return m_Tolerance; }

	virtual void stageInit();
	virtual void stageMain();
	virtual void stageEnd();
	virtual string getLatexName() const;
	virtual string getShortName() const;

	virtual shared_ptr<TFloatField3> getDistance() const { return m_Distance; };
	virtual shared_ptr<TOrigSetField2> getOrigins() const { throw string("Invalid operation"); return m_Origins; }
	virtual shared_ptr<class TIndexedOriginsField> getIndexedOrigins() const { return m_IndexedOrigins; }
	virtual shared_ptr<class TBoundary> getBoundary() const { return m_Boundary; }
	virtual shared_ptr<class TFlagField3> getFlagField() const { return m_FlagField; }
	virtual shared_ptr<class TCoord3SetSortedField> getBoundaryPixelToObjectPixels() const { return m_BoundaryPixelToObjectPixels; }

	void removeSpuriousBoundaryPoints();

	virtual void deleteFields();

protected:
	float m_Tolerance;
	int m_Tolerance2;
	const TFloatField3 * m_Image;
	shared_ptr<TFloatField3> m_Distance;
	shared_ptr<TOrigSetField2> m_Origins;
	shared_ptr<TFlagField3> m_FlagField;
	shared_ptr<TIndexedOriginsField> m_IndexedOrigins;
	shared_ptr<TBoundary> m_Boundary;
	shared_ptr<TCoord3SetSortedField> m_BoundaryPixelToObjectPixels;

};

#endif
