#include "stdafx.h"

#include "fieldadaptors.h"
#include "abstractfilter.h"
#include "skeletonizer.h"
#include "layer.h"
#include "globals.h"

shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_Length::getDefaultMeasure() 
{ 
	return shared_ptr<TMeasure>(new TFloatFieldMeasure_Identity(this)); 
}

// ----------------

shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_PathSet::getDefaultMeasure() 
{ 
	return shared_ptr<TMeasure>(new TIndexedOriginsFieldMeasure_CoordCount(this)); 
}
 
void TShortestPathSetFieldAdaptor_PathSet::accept(TFieldVisitor * v)
{ 
//	v->visitIndexedOriginsField( const_cast<TTypedFieldInterface<class TIndexedOrigins*>* >(this) ); 
	v->visitIndexedOriginsField(this);
}

TField * TShortestPathSetFieldAdaptor_PathSet::create(const TField * p_AdaptedField) const
{ 
	if(p_AdaptedField == 0) throw string("TShortestPathSetFieldAdaptor_PathSet::create(): p_AdaptedField == 0");
	return new TShortestPathSetFieldAdaptor_PathSet(static_cast<TTypedFieldInterface<TShortestPathSet*> *>( const_cast<TField*>(p_AdaptedField) ) ); 
}

shared_ptr<TIndexMapper> TShortestPathSetFieldAdaptor_PathSet::getIndexToField() const
{
	return g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField;
}

// ----------------

shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_Midpoints::getDefaultMeasure() { return shared_ptr<TMeasure>(new TIndexedOriginsFieldMeasureMultimap_Maximum(this)); }

TShortestPathSetFieldAdaptor_Midpoints::TShortestPathSetFieldAdaptor_Midpoints(TTypedFieldInterface<TShortestPathSet*> * p_SpSetField)
	: TShortestPathSetFieldAdaptor<TIndexedOrigins_Multimap*>(p_SpSetField)
{
};

TIndexedOrigins_Multimap * const TShortestPathSetFieldAdaptor_Midpoints::vvaluep(const TCoord3 & p) const
{ 
	if(! m_SpSetField->vvaluep(p)) return 0;
	
	mm.clear();
	const TShortestPathSet * sps = m_SpSetField->vvaluep(p);
	TShortestPathSet::TPaths::const_iterator it;
	for(it = sps->m_Paths.begin(); it != sps->m_Paths.end(); it++)
	{
		mm.insert( TIndexedOrigins_Multimap::value_type( (*it)->m_Length, (*it)->getMiddle() ) );
	}
	return &mm;
}

TField * TShortestPathSetFieldAdaptor_Midpoints::create(const TField * p_AdaptedField) const
{ 
	return new TShortestPathSetFieldAdaptor_Midpoints(static_cast<TTypedFieldInterface<TShortestPathSet*> *>( const_cast<TField*>(p_AdaptedField) ) ); 
}

shared_ptr<TIndexMapper> TShortestPathSetFieldAdaptor_Midpoints::getIndexToField() const
{
	return g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField;
}

// ----------------

shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_Eft::getDefaultMeasure() 
{ 
	return shared_ptr<TMeasure>(new TIndexedOriginsFieldMeasure_CoordCount(this)); 
}
 
void TShortestPathSetFieldAdaptor_Eft::accept(TFieldVisitor * v)
{ 
	v->visitIndexedOriginsField(this);
}

TField * TShortestPathSetFieldAdaptor_Eft::create(const TField * p_AdaptedField) const
{ 
	if(p_AdaptedField == 0) throw string("TShortestPathSetFieldAdaptor_Eft::create(): p_AdaptedField == 0");
	return new TShortestPathSetFieldAdaptor_Eft(static_cast<TTypedFieldInterface<TShortestPathSet*> *>( const_cast<TField*>(p_AdaptedField) ) ); 
}

shared_ptr<TIndexMapper> TShortestPathSetFieldAdaptor_Eft::getIndexToField() const
{
	return g_Mediator.getSkeletonizer()->m_BackgroundBoundaryIndexField;
}

// ----------------

shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_Seft::getDefaultMeasure() 
{ 
	return shared_ptr<TMeasure>(new TIndexedOriginsFieldMeasure_CoordCount(this)); 
}
 
void TShortestPathSetFieldAdaptor_Seft::accept(TFieldVisitor * v)
{ 
	v->visitIndexedOriginsField(this);
}

TField * TShortestPathSetFieldAdaptor_Seft::create(const TField * p_AdaptedField) const
{ 
	if(p_AdaptedField == 0) throw string("TShortestPathSetFieldAdaptor_Seft::create(): p_AdaptedField == 0");
	return new TShortestPathSetFieldAdaptor_Seft(static_cast<TTypedFieldInterface<TShortestPathSet*> *>( const_cast<TField*>(p_AdaptedField) ) ); 
}

shared_ptr<TIndexMapper> TShortestPathSetFieldAdaptor_Seft::getIndexToField() const
{
	return g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField;
}


// ----------------

TShortestPathSetFieldAdaptor_FilteredPathSet::TShortestPathSetFieldAdaptor_FilteredPathSet(TTypedFieldInterface<TShortestPathSet*> * p_SpSetField)
	: TShortestPathSetFieldAdaptor<TShortestPathSet*>(p_SpSetField)
	, volatilesps()
{
	if(p_SpSetField != 0)
	{
		m_ObservingLayer = g_Mediator.getSkeletonizer().get()->m_SurfaceSkeletonField->getLayer();
		m_ObservingLayer->registerObserver(this);
	}
};


TShortestPathSet* const TShortestPathSetFieldAdaptor_FilteredPathSet::vvaluep(const TCoord3 & p) const
{ 
	if(! m_SpSetField->vvaluep(p)) return 0;
	if(!volatileEft) volatileEft.reset( new TIndexedOrigins_Vector() );

	const TFilter * Filter = g_Mediator.getSkeletonizer().get()->m_SurfaceSkeletonField->getLayer()->m_Filter.get();
	const TShortestPathSet * sps = m_SpSetField->vvaluep(p);
	volatilesps = TShortestPathSet( *sps );
	TShortestPathSet::TPaths::const_iterator it;
	volatilesps.m_Eft = volatileEft;
	volatileEft->clear();
	TShortestPathSet::TPaths NewPaths;
	for(it = sps->m_Paths.begin(); it != sps->m_Paths.end(); it++)
	{
		shared_ptr<TShortestPath> sp = *it;
		if( Filter->test(sp->m_Length) )
		{
			NewPaths.push_back( sp );
			volatileEft->push_back( sp->m_Begin );
			volatileEft->push_back( sp->m_End );
		}
	}
	if(NewPaths.size() == 0) return 0; // If no paths left after filtering return null
	volatilesps.m_Paths = NewPaths;
	
	return &volatilesps;
}

TShortestPathSet* const TShortestPathSetFieldAdaptor_FilteredPathSet::vvaluex(unsigned int idx) const
{
	return vvaluep( getIndexField()->vidx2coord(idx) );
}



// ----------------


shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_FpAngle::getDefaultMeasure() 
{ 
	return shared_ptr<TMeasure>(new TFloatFieldMeasure_Identity(this)); 
}
 
void TShortestPathSetFieldAdaptor_FpAngle::accept(TFieldVisitor * v)
{ 
	v->visitFloatField(this);
}

TField * TShortestPathSetFieldAdaptor_FpAngle::create(const TField * p_AdaptedField) const
{ 
	if(p_AdaptedField == 0) throw string("TShortestPathSetFieldAdaptor_FpAngle::create(): p_AdaptedField == 0");
	return new TShortestPathSetFieldAdaptor_FpAngle(static_cast<TTypedFieldInterface<TShortestPathSet*> *>( const_cast<TField*>(p_AdaptedField) ) ); 
}

const float TShortestPathSetFieldAdaptor_FpAngle::vvaluep(const TCoord3 & p) const
{
	const TShortestPathSet * sps = m_SpSetField->vvaluep(p);
	TShortestPathSet::TPaths::const_iterator it;
	TShortestPathSet::TPaths NewPaths;
	
	float maxdot = (std::numeric_limits<float>::max)();
	if(!sps) return maxdot;

	for(it = sps->m_Paths.begin(); it != sps->m_Paths.end(); it++)
	{
		shared_ptr<TShortestPath> sp = *it;
		TVector3 v1 = g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField->vidx2coord(sp->m_Begin).toVector();
		TVector3 v2 = g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField->vidx2coord(sp->m_End).toVector();

		v1.subtract(p.toVector());
		v1.normalize();
		v2.subtract(p.toVector());
		v2.normalize();
		const float d = v1.dot(v2);
		if(d < maxdot) maxdot = d;
	}
	if(maxdot > 0.999f) maxdot = 0.999f;
	else if(maxdot < -0.999f) maxdot = -0.999f;
	return acos(maxdot) / PI * 180.0f;
}

const float TShortestPathSetFieldAdaptor_FpAngle::vvaluex(unsigned int x) const
{
	return vvaluep(m_SpSetField->getIndexField()->vidx2coord(x));
}

// ----------------



shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_Radius::getDefaultMeasure() 
{ 
	return shared_ptr<TMeasure>(new TFloatFieldMeasure_Identity(this)); 
}
 
void TShortestPathSetFieldAdaptor_Radius::accept(TFieldVisitor * v)
{ 
	v->visitFloatField(this);
}

TField * TShortestPathSetFieldAdaptor_Radius::create(const TField * p_AdaptedField) const
{ 
	if(p_AdaptedField == 0) throw string("TShortestPathSetFieldAdaptor_Radius::create(): p_AdaptedField == 0");
	return new TShortestPathSetFieldAdaptor_Radius(static_cast<TTypedFieldInterface<TShortestPathSet*> *>( const_cast<TField*>(p_AdaptedField) ) ); 
}

const float TShortestPathSetFieldAdaptor_Radius::vvaluep(const TCoord3 & p) const
{
	const TShortestPathSet * sps = m_SpSetField->vvaluep(p);
	TShortestPathSet::TPaths::const_iterator it;
	TShortestPathSet::TPaths NewPaths;
	
	float maxdist = 0.0f;
	if(!sps) return maxdist;

	for(it = sps->m_Paths.begin(); it != sps->m_Paths.end(); it++)
	{
		shared_ptr<TShortestPath> sp = *it;
		{
			const float dist = sps->m_SourceVoxel.distance( g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField->vidx2coord(sp->m_Begin) );
			if(dist > maxdist) maxdist = dist;
		}

		{
			const float dist = sps->m_SourceVoxel.distance( g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField->vidx2coord(sp->m_End) );
			if(dist > maxdist) maxdist = dist;
		}
	}
	return maxdist;
}

const float TShortestPathSetFieldAdaptor_Radius::vvaluex(unsigned int x) const
{
	return vvaluep(m_SpSetField->getIndexField()->vidx2coord(x));
}


// ----------------



shared_ptr<class TMeasure> TShortestPathSetFieldAdaptor_MaxPathVoxelDistance::getDefaultMeasure() 
{ 
	return shared_ptr<TMeasure>(new TFloatFieldMeasure_Identity(this)); 
}
 
void TShortestPathSetFieldAdaptor_MaxPathVoxelDistance::accept(TFieldVisitor * v)
{ 
	v->visitFloatField(this);
}

TField * TShortestPathSetFieldAdaptor_MaxPathVoxelDistance::create(const TField * p_AdaptedField) const
{ 
	if(p_AdaptedField == 0) throw string("TShortestPathSetFieldAdaptor_Radius::create(): p_AdaptedField == 0");
	return new TShortestPathSetFieldAdaptor_MaxPathVoxelDistance(static_cast<TTypedFieldInterface<TShortestPathSet*> *>( const_cast<TField*>(p_AdaptedField) ) ); 
}

const float TShortestPathSetFieldAdaptor_MaxPathVoxelDistance::vvaluep(const TCoord3 & p) const
{
	const TShortestPathSet * sps = m_SpSetField->vvaluep(p);

	if(!sps) return 0.0f;
	return sps->getMaxLength() / sps->getRadius();
}

const float TShortestPathSetFieldAdaptor_MaxPathVoxelDistance::vvaluex(unsigned int x) const
{
	return vvaluep(m_SpSetField->getIndexField()->vidx2coord(x));
}

