#ifndef FILTER_H
#define FILTER_H


#include "stdafx.h"
#include "abstractmeasure.h"
#include "abstractfilter.h"
#include "field.h"
#include "controls.h"
#include "indexedorigins.h"
#include "indexedoriginsfield.h"
#include "indexedorigins_pool.h"




class TMeasureNone : public TMeasure
{
public:
	TMeasureNone() 
		: TMeasure(0) 
	{
	};

	virtual float toFloat(const TCoord3 & p_Coord) const { return 0; }
	virtual float vvaluex(const unsigned int x) const { return 0; }
	virtual string getName() const { return "none"; }
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_NONE; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_NONE; }
	virtual TMeasure * create(TField * p_Field) const { return new TMeasureNone(); }
};


class TIntFieldMeasure_Identity : public TTypedMeasure<int> 
{
public:
	TIntFieldMeasure_Identity(TTypedFieldInterface<int> * p_Field) : TTypedMeasure<int>(p_Field)
	{
	}
	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p); }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x); }
	virtual string getName() const { return "int identity"; }
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INT_IDENTITY; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INT; }
	virtual TMeasure * create(TField * p_Field) const { return new TIntFieldMeasure_Identity(static_cast<TTypedFieldInterface<int>*>(p_Field)); }
};

class TUintFieldMeasure_Identity : public TTypedMeasure<unsigned int> 
{
public:
	TUintFieldMeasure_Identity(TTypedFieldInterface<unsigned int> * p_Field) : TTypedMeasure<unsigned int>(p_Field)
	{
	}
	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p); }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x); }
	virtual string getName() const { return "uint identity"; }
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_UINT_IDENTITY; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_UINT; }
	virtual TMeasure * create(TField * p_Field) const { return new TUintFieldMeasure_Identity(static_cast<TTypedFieldInterface<unsigned int>*>(p_Field)); }
};

class TUnsignedCharFieldMeasure_Identity : public TTypedMeasure<unsigned char>
{
public:
	TUnsignedCharFieldMeasure_Identity(TTypedFieldInterface<unsigned char> * p_Field) : TTypedMeasure<unsigned char>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p); }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x); }
	virtual string getName() const { return "uchar identity"; }
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_UCHAR_IDENTITY; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_UCHAR; }
	virtual TMeasure * create(TField * p_Field) const { return new TUnsignedCharFieldMeasure_Identity(static_cast<TTypedFieldInterface<unsigned char>*>(p_Field)); }
};

class TFloatFieldMeasure_Identity : public TTypedMeasure<float> 
{
public:
	TFloatFieldMeasure_Identity(TTypedFieldInterface<float> * p_Field)
		: TTypedMeasure<float>(p_Field)
	{
	}
	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p); }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x); }
	virtual string getName() const { return "float identity"; }
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_FLOAT_IDENTITY; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_FLOAT; }
	virtual TMeasure * create(TField * p_Field) const { return new TFloatFieldMeasure_Identity(static_cast<TTypedFieldInterface<float>*>(p_Field)); }
};

class TFloatFieldMeasure_Sqrt : public TTypedMeasure<float> 
{
public:
	TFloatFieldMeasure_Sqrt(TTypedFieldInterface<float> * p_Field)
		: TTypedMeasure<float>(p_Field)
	{
	}
	virtual float toFloat(const TCoord3 & p) const { return sqrtf(m_Field->vvaluep(p)); }
	virtual float vvaluex(const unsigned int x) const { return sqrtf(m_Field->vvaluex(x)); }
	virtual string getName() const { return "float sqrtf"; }
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_FLOAT_SQRT; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_FLOAT; }
	virtual TMeasure * create(TField * p_Field) const { return new TFloatFieldMeasure_Sqrt(static_cast<TTypedFieldInterface<float>*>(p_Field)); }
};

class TFloatFieldMeasure_Normalized : public TTypedMeasure<float> 
{
public:
	TFloatFieldMeasure_Normalized(TTypedFieldInterface<float> * p_Field)
		: TTypedMeasure<float>(p_Field)
	{
	}
	virtual float toFloat(const TCoord3 & p) const;
	virtual float vvaluex(const unsigned int x) const { return toFloat( m_Field->getIndexField()->vidx2coord(x) ); }

	virtual string getName() const; 
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_FLOAT_NORMALIZED; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_FLOAT; }
	virtual TMeasure * create(TField * p_Field) const { return new TFloatFieldMeasure_Normalized(static_cast<TTypedFieldInterface<float>*>(p_Field)); }
protected:
};




class TVector3FieldMeasure_Length : public TTypedMeasure<TVector3>
{
public:
	TVector3FieldMeasure_Length(TTypedFieldInterface<TVector3> * p_Field) : TTypedMeasure<TVector3>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p).length(); }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x).length(); }

	virtual string getName() const { return "vector3 length"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_VECTOR3_LENGTH; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_VECTOR3; }
	virtual TMeasure * create(TField * p_Field) const { return new TVector3FieldMeasure_Length(static_cast<TTypedFieldInterface<TVector3> *>(p_Field)); }
};

class TIndexedOriginsFieldMeasure_CoordCount : public TTypedMeasure<class TIndexedOrigins*>
{
public:
//	TIndexedOriginsFieldMeasure_CoordCount(class TTypedFieldInterface<class TIndexedOrigins*> * p_Field) 
	TIndexedOriginsFieldMeasure_CoordCount(TTypedFieldInterface<TIndexedOrigins*> * p_Field) 
		: TTypedMeasure<TIndexedOrigins*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p) ? m_Field->vvaluep(p)->vertexcount() : 0; }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x) ? m_Field->vvaluex(x)->vertexcount() : 0; }

	virtual string getName() const { return "voxel count"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INDEXEDORIGINS_COUNT; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INDEXEDORIGINS; }
	virtual TMeasure * create(TField * p_Field) const { return new TIndexedOriginsFieldMeasure_CoordCount(static_cast<TTypedFieldInterface<TIndexedOrigins*>*>(p_Field)); }
};


class TIndexedOriginsFieldMeasure_MinDistance : public TTypedMeasure<class TIndexedOrigins*>
{
public:
//	TIndexedOriginsFieldMeasure_CoordCount(class TTypedFieldInterface<class TIndexedOrigins*> * p_Field) 
	TIndexedOriginsFieldMeasure_MinDistance(TTypedFieldInterface<TIndexedOrigins*> * p_Field) 
		: TTypedMeasure<TIndexedOrigins*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const; 
	virtual float vvaluex(const unsigned int x) const { return toFloat( m_Field->getIndexField()->vidx2coord(x) ); }


	virtual string getName() const { return "minimum distance"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INDEXEDORIGINS_MINDISTANCE; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INDEXEDORIGINS; }
	virtual TMeasure * create(TField * p_Field) const { return new TIndexedOriginsFieldMeasure_MinDistance(static_cast<TTypedFieldInterface<TIndexedOrigins*>*>(p_Field)); }
};

class TIndexedOriginsFieldMeasureMultimap_Minimum : public TTypedMeasure<class TIndexedOrigins_Multimap*>
{
public:
	TIndexedOriginsFieldMeasureMultimap_Minimum(TTypedFieldInterface<TIndexedOrigins_Multimap*> * p_Field) 
		: TTypedMeasure<TIndexedOrigins_Multimap*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { const TIndexedOrigins_Multimap * v = m_Field->vvaluep(p); return v && v->size() > 0 ? v->begin()->first : 0; }
	virtual float vvaluex(const unsigned int x) const { const TIndexedOrigins_Multimap * v = m_Field->vvaluex(x); return v && v->size() > 0 ? v->begin()->first : 0; }

	virtual string getName() const { return "minimum"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MIN; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INDEXEDORIGINS_MULTIMAP; }
	virtual TMeasure * create(TField * p_Field) const { return new TIndexedOriginsFieldMeasureMultimap_Minimum(static_cast<TTypedFieldInterface<TIndexedOrigins_Multimap*>*>(p_Field)); }
};

class TIndexedOriginsFieldMeasureMultimap_Maximum : public TTypedMeasure<class TIndexedOrigins_Multimap*>
{
public:
	TIndexedOriginsFieldMeasureMultimap_Maximum(TTypedFieldInterface<TIndexedOrigins_Multimap*> * p_Field) 
		: TTypedMeasure<TIndexedOrigins_Multimap*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { const TIndexedOrigins_Multimap * v = m_Field->vvaluep(p); return v && v->size() > 0 ? v->rbegin()->first : 0; }
	virtual float vvaluex(const unsigned int x) const { const TIndexedOrigins_Multimap * v = m_Field->vvaluex(x); return v && v->size() > 0 ? v->rbegin()->first : 0; }

	virtual string getName() const { return "maximum"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MAX; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INDEXEDORIGINS_MULTIMAP; }
	virtual TMeasure * create(TField * p_Field) const { return new TIndexedOriginsFieldMeasureMultimap_Maximum(static_cast<TTypedFieldInterface<TIndexedOrigins_Multimap*>*>(p_Field)); }
};

class TIndexedOriginsFieldMeasureMultimap_MinDistance : public TTypedMeasure<class TIndexedOrigins_Multimap*>
{
public:
	TIndexedOriginsFieldMeasureMultimap_MinDistance(TTypedFieldInterface<TIndexedOrigins_Multimap*> * p_Field) 
		: TTypedMeasure<TIndexedOrigins_Multimap*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const;
	virtual float vvaluex(const unsigned int x) const { return toFloat( m_Field->getIndexField()->vidx2coord(x) ); }

	virtual string getName() const { return "minimum distance"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MINDISTANCE; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INDEXEDORIGINS_MULTIMAP; }
	virtual TMeasure * create(TField * p_Field) const { return new TIndexedOriginsFieldMeasureMultimap_MinDistance(static_cast<TTypedFieldInterface<TIndexedOrigins_Multimap*>*>(p_Field)); }
};

class TIndexedOriginsFieldMeasureMultimap_MaxDistance : public TTypedMeasure<class TIndexedOrigins_Multimap*>
{
public:
	TIndexedOriginsFieldMeasureMultimap_MaxDistance(TTypedFieldInterface<TIndexedOrigins_Multimap*> * p_Field) 
		: TTypedMeasure<TIndexedOrigins_Multimap*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const;
	virtual float vvaluex(const unsigned int x) const { return toFloat( m_Field->getIndexField()->vidx2coord(x) ); }

	virtual string getName() const { return "maximum distance"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MAXDISTANCE; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INDEXEDORIGINS_MULTIMAP; }
	virtual TMeasure * create(TField * p_Field) const { return new TIndexedOriginsFieldMeasureMultimap_MaxDistance(static_cast<TTypedFieldInterface<TIndexedOrigins_Multimap*>*>(p_Field)); }
};

class TIndexedOriginsFieldMeasureMultimap_OriginCount : public TTypedMeasure<class TIndexedOrigins_Multimap*>
{
public:
	TIndexedOriginsFieldMeasureMultimap_OriginCount(TTypedFieldInterface<TIndexedOrigins_Multimap*> * p_Field) 
		: TTypedMeasure<TIndexedOrigins_Multimap*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const;
	virtual float vvaluex(const unsigned int x) const { return toFloat( m_Field->getIndexField()->vidx2coord(x) ); }

	virtual string getName() const { return "count"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_INDEXEDORIGINS_MULTIMAP_ORIGINCOUNT; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_INDEXEDORIGINS_MULTIMAP; }
	virtual TMeasure * create(TField * p_Field) const { return new TIndexedOriginsFieldMeasureMultimap_OriginCount(static_cast<TTypedFieldInterface<TIndexedOrigins_Multimap*>*>(p_Field)); }
};




class TCoord3SetFieldMeasure : public TMeasure
{
public:
	TCoord3SetFieldMeasure(TTypedFieldInterface<vector<TCoord3>*> * p_Field) 
		: m_Field(p_Field), TMeasure(p_Field) {};
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COORD3SET; }
protected:
	TTypedFieldInterface<vector<TCoord3>*>* m_Field;
};

class TCoord3SetField_CoordCount : public TCoord3SetFieldMeasure
{
public:
	TCoord3SetField_CoordCount(TTypedFieldInterface<vector<TCoord3>*> * p_Field) : TCoord3SetFieldMeasure(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p) ? m_Field->vvaluep(p)->size() : 0; }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x) ? m_Field->vvaluex(x)->size() : 0; }

	virtual string getName() const { return "voxel count"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_COORD3SET_COUNT; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COORD3SET; }
	virtual TMeasure * create(TField * p_Field) const { return new TCoord3SetField_CoordCount(static_cast<TTypedFieldInterface<vector<TCoord3>*>*>(p_Field)); }
};



class TCoord3WithFloatSetFieldMeasure : public TMeasure
{
public:
	TCoord3WithFloatSetFieldMeasure(TTypedFieldInterface<vector<pair<TCoord3,float> >*> * p_Field) 
		: m_Field(p_Field), TMeasure(p_Field) {};
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COORD3SET; }
protected:
	TTypedFieldInterface<vector<pair<TCoord3,float> >*>* m_Field;
};

class TCoord3WithFloatSetField_CoordCount : public TCoord3WithFloatSetFieldMeasure
{
public:
	TCoord3WithFloatSetField_CoordCount(TTypedFieldInterface<vector<pair<TCoord3,float> >*> * p_Field) : TCoord3WithFloatSetFieldMeasure(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p) ? m_Field->vvaluep(p)->size() : 0; }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x) ? m_Field->vvaluex(x)->size() : 0; }
	

	virtual string getName() const { return "voxel count"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_COORD3WITHFLOATSET_COUNT; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COORD3WITHFLOATSET; }
	virtual TMeasure * create(TField * p_Field) const { return new TCoord3WithFloatSetField_CoordCount(static_cast<TTypedFieldInterface<vector<pair<TCoord3,float> >*> *>(p_Field)); }
};

class TCoord3WithFloatSetField_Minimum : public TCoord3WithFloatSetFieldMeasure
{
public:
	TCoord3WithFloatSetField_Minimum(TTypedFieldInterface<vector<pair<TCoord3,float> >*> * p_Field) : TCoord3WithFloatSetFieldMeasure(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const;
	virtual float vvaluex(const unsigned int x) const { return toFloat( m_Field->getIndexField()->vidx2coord(x) ); }

	virtual string getName() const { return "minimum"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_COORD3WITHFLOATSET_MINIMUM; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COORD3WITHFLOATSET; }
	virtual TMeasure * create(TField * p_Field) const { return new TCoord3WithFloatSetField_Minimum(static_cast<TTypedFieldInterface<vector<pair<TCoord3,float> >*> *>(p_Field)); }
};

class TCoord3WithFloatSetField_Maximum : public TCoord3WithFloatSetFieldMeasure
{
public:
	TCoord3WithFloatSetField_Maximum(TTypedFieldInterface<vector<pair<TCoord3,float> >*> * p_Field) : TCoord3WithFloatSetFieldMeasure(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const;
	virtual float vvaluex(const unsigned int x) const { return toFloat( m_Field->getIndexField()->vidx2coord(x) ); }

	virtual string getName() const { return "maximum"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_COORD3WITHFLOATSET_MAXIMUM; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COORD3WITHFLOATSET; }
	virtual TMeasure * create(TField * p_Field) const { return new TCoord3WithFloatSetField_Minimum(static_cast<TTypedFieldInterface<vector<pair<TCoord3,float> >*> *>(p_Field)); }
};









class TTrueFilter : public TAbstractFilter 
{
public:
	virtual const bool test(const TCoord3 & p) const { return true; }
	virtual const bool test(float v) const { return true; }
	virtual const bool testx(const unsigned int & x) const { return true; }
};

class TFilterAlwaysTrue : public TFilter 
{
public:
	TFilterAlwaysTrue(shared_ptr<TMeasure> * const p_Measure) 
		: TFilter(p_Measure) 
	{ 
		m_Name = "always true"; 
	}
	virtual void DrawGui(wxWindow * p_Window);
	virtual const bool test(const TCoord3 & p) const
	{
		return true;
	}
	virtual FILTERTYPE getFilterType() const { return FILTERTYPE_ALWAYSTRUE; }
	virtual void setAlwaysTrue(bool b) {};
};


class TInvertFilter : public TAbstractFilter 
{
public:
	TInvertFilter(TFilter * p_Filter) 
		: m_Filter(p_Filter)
	{ 
	}
	virtual const bool test(const TCoord3 & p) const {	return !m_Filter->test(p); }; 
	virtual const bool test(float v) const {	return !m_Filter->test(v); };
	virtual const bool testx(const unsigned int & x) const {	return !m_Filter->testx(x); };
protected:
	TFilter * m_Filter;
};

class TFloatFilter : public TFilter
{
public:
	friend class TFloatFilterPanel;

	TFloatFilter(shared_ptr<TMeasure> * const p_Measure)  
		: TFilter(p_Measure)
		, m_LowerValue( (*p_Measure)->getMinValue()  )
		, m_UpperValue( (*p_Measure)->getMaxValue()  ) 
		, m_AlwaysTrue(false) 
	{};

	virtual string getName() const 
	{ 
		if(m_Name == "noname") return string( wxString::Format("%.2f to %.2f", m_LowerValue, m_UpperValue) );
		else return m_Name;
	}
	virtual const bool testx(const unsigned int & x) const 
	{
		const float v = (*m_Measure)->vvaluex(x);
		return v >= m_LowerValue && v <= m_UpperValue;
	}
	virtual const bool test(const TCoord3 & p) const 
	{
		return m_AlwaysTrue || (((*m_Measure)->toFloat(p) >= m_LowerValue) && ((*m_Measure)->toFloat(p) <= m_UpperValue));
	}
	virtual const bool test(float v) const
	{
		return m_AlwaysTrue || ((v >= m_LowerValue) && (v <= m_UpperValue));
	}
	virtual FILTERTYPE getFilterType() const { return FILTERTYPE_FLOAT; }
	virtual void setAlwaysTrue(bool b) { m_AlwaysTrue = b; }
	inline bool getAlwaysTrue() { return m_AlwaysTrue; }
	
	virtual void DrawGui(wxWindow * p_Window);

	float m_LowerValue;
	float m_UpperValue;
	bool m_AlwaysTrue;
protected:
};




class TFloatFilterPanel : public wxPanel
{
public:
	TFloatFilterPanel(TFloatFilter * p_Filter, wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL);
	virtual ~TFloatFilterPanel()
	{
	}

protected:
	enum { ID_LOWERVALUE = 1, ID_UPPERVALUE, ID_ALWAYSTRUE }; 
	TFloatFilter * m_Filter;

	wxSpinCtrlForFloats * m_SpinCtrlLower;
	wxSpinCtrlForFloats * m_SpinCtrlUpper;
	wxCheckBox * m_CheckBoxAlwaysTrue;

	void OnChangeLower(wxCommandEvent & event);
	void OnChangeUpper(wxCommandEvent & event);
	void OnChangeAlwaysTrue(wxCommandEvent & event);
};


class TMeasuresBox : public wxComboBox
{
public:
	TMeasuresBox(wxWindow* parent, wxWindowID id, const wxString& value = "", const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize);

	void fillForSourceType(TType::TYPE p_FieldType, TMeasure::MEASURETYPE p_MeasureType);
	TMeasure * getCloneOfSelectedMeasure(TField * p_Field) const 
	{ 
		const TMeasure * ExistingMeasure = static_cast<TMeasure*>( this->GetClientData(this->GetSelection()) );
		TMeasure * NewMeasure = ExistingMeasure->create(p_Field);
		return NewMeasure;
	}

	void fill();
	TMeasure * getMeasureForFieldType(TField * p_Field)
	{
		for(int i=0; i<m_MeasurePrototypes.size(); i++)	
		{
			if( m_MeasurePrototypes[i]->getSourceType() == p_Field->getType())
			{
				TMeasure * Measure = static_cast<TMeasure*>(m_MeasurePrototypes[i].get());
				return Measure->create(p_Field); 
			}
		}
		return 0;
	}

protected:
	vector<shared_ptr<TMeasure> >  m_MeasurePrototypes; 
};





#endif


