#include "stdafx.h"

#include "font.h"

#include "wx/bitmap.h"
#include "wx/image.h"
#include "wx/file.h"
#include "renderer.h"
#include "utils.h"

TFont::TFont()
{
  // vars
    int red          = 0;
    int green        = 0;
    int blue         = 0;

	const int CHARSETSIZE = 128;
	m_CharWidth = 16;
	m_CharHeight = 32;

	m_TexIds.resize(CHARSETSIZE, 0);

    // allocate textures
    glGenTextures( CHARSETSIZE, &(m_TexIds[0]) );

	// buffer for texture read
	vector<GLubyte> TexBuffer;
	TexBuffer.resize( m_CharWidth * m_CharHeight * 4 );

    // create textures
    for ( int i = 0; i < CHARSETSIZE; ++i )
    {
        // load bitmap
		wxString s = wxString::Format( "Font/%i.bmp", i );
        string path = s.c_str();
		if( !wxFile::Exists( path.c_str() ) )
		{
			// Chars not available point to space
			glBindTexture( GL_TEXTURE_2D, m_TexIds[32] );
		}
		else
		{
			shared_ptr<wxBitmap> bitmap(  new wxBitmap( wxString( path ), wxBITMAP_TYPE_BMP ) );

			if ( bitmap->Ok() == true )
			{
				// bind textures
				glBindTexture( GL_TEXTURE_2D, m_TexIds[i] );
				// create image
				wxImage image = bitmap->ConvertToImage();
            
				// read in texture
				 
				int count = 0;
				for ( int h = 0; h < m_CharHeight; ++h )
				{
					for ( int w = 0; w < m_CharWidth; ++w )
					{
						red   = (GLubyte)image.GetRed( w, h );
						green = (GLubyte)image.GetGreen( w, h );
						blue  = (GLubyte)image.GetBlue( w, h );

						TexBuffer[count*4 + 0] = 255;
						TexBuffer[count*4 + 1] = 255;
						TexBuffer[count*4 + 2] = 255;
						TexBuffer[count*4 + 3] = 255-( red+green+blue )/3.0;
						++count;
					}
				}

				// Build texture
	// /*
				glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
				gluBuild2DMipmaps(
					GL_TEXTURE_2D, 
					4, 
					m_CharWidth, 
					m_CharHeight,
					GL_RGBA, 
					GL_UNSIGNED_BYTE, 
					&(TexBuffer[0]) );                    
				checkGlError();
	// */

	 /* 
				glTexImage2D(
					GL_TEXTURE_2D,
					0, // level 
					//GL_ALPHA,
					4, // component
					//GL_ALPHA, 
					m_CharWidth, 
					m_CharHeight,
					0, // border 
					GL_ALPHA, 
					GL_UNSIGNED_BYTE, 
					&(TexBuffer[0]) );                    
	// */
					
			}
			else
				throw string( "Error loading fonts." );


		}
    }


};


TFont::~TFont()
{
	glDeleteTextures(m_TexIds.size(), &(m_TexIds[0]) );
}


void TFont::renderText(const string p_Text, int p_Align)
{
	glEnable( GL_TEXTURE_2D );

	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );

	TRenderer Renderer;
	Renderer.begin();

	glEnable( GL_BLEND );
	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

	glDisable(GL_CULL_FACE);
	glDisable(GL_LIGHTING);
	glDepthMask(false);
	
//	const float scaling = 0.1f;

	const float width = getWidth();
	const float height = getHeight();

	float p_X = 0;
	float p_Y = 0;

	if( p_Align & FONT_RIGHTALIGN ) 
		p_X -= p_Text.size() * width;

	if( p_Align & FONT_TOPALIGN ) 
		p_Y -= height;

	for(unsigned int i=0; i<p_Text.size(); i++)
	{
		char c = p_Text[i];
		glBindTexture( GL_TEXTURE_2D, m_TexIds[c] );

        glBegin( GL_QUADS );
            glTexCoord2f( 0.0, 0.0 ); glVertex3f( p_X + width*i , p_Y + height, 0.0f );
            glTexCoord2f( 0.0, 1.0 ); glVertex3f( p_X +width*i , p_Y + 0.0f, 0.0f );
            glTexCoord2f( 1.0, 1.0 ); glVertex3f( p_X +width*(i+1) , p_Y + 0.0f, 0.0f );
            glTexCoord2f( 1.0, 0.0 ); glVertex3f( p_X +width*(i+1) , p_Y + height, 0.0f );
        glEnd();
	}

//	glDisable( GL_BLEND );
//	glEnable(GL_CULL_FACE);
//	glEnable(GL_LIGHTING);

	Renderer.end();
	glDisable( GL_TEXTURE_2D );
}

