#include "stdafx.h"

#include "geodesiccache.h"

GeodesicCache::GeodesicCache(double minCachedPathLength, int maxCacheSize)
	: minCachedPathLength(minCachedPathLength), maxCacheSize(maxCacheSize)
{

}

std::shared_ptr<TShortestPath> GeodesicCache::GetShortestPath(unsigned int beginIndex, unsigned int endIndex, PathComputer& computer)
{
	std::shared_ptr<const TShortestPath> path = TryGet(beginIndex, endIndex);

	if (path == nullptr)
	{
		path = computer.ComputeShortestPath(beginIndex, endIndex);
		if (path == nullptr) return nullptr;
		TryAdd(beginIndex, endIndex, path);
	}

	return std::shared_ptr<TShortestPath>(new TShortestPath(*path));
}

std::shared_ptr<const TShortestPath> GeodesicCache::TryGet(unsigned int beginIndex, unsigned int endIndex)
{
	wxMutexLocker lock(mutex);

	unordered_map<std::pair<unsigned int, unsigned int>, std::shared_ptr<const TShortestPath>>::const_iterator iterator =
		cache.find(std::pair<unsigned int, unsigned int>(beginIndex, endIndex));

	if (iterator == cache.end())
		return nullptr;

	return iterator->second;
}

void GeodesicCache::TryAdd(unsigned int beginIndex, unsigned int endIndex, std::shared_ptr<const TShortestPath> path)
{
	if (path->m_Length >= minCachedPathLength && cache.size() < maxCacheSize)
	{
		wxMutexLocker lock(mutex);

		if (cache.size() < maxCacheSize)
			cache[std::pair<unsigned int, unsigned int>(beginIndex, endIndex)] = path;
	}
}
