#pragma once

#include "stdafx.h"

#include "shortestpath.h"

class PathComputer
{
public:
	virtual std::shared_ptr<TShortestPath> ComputeShortestPath(unsigned int beginIndex, unsigned int endIndex) = 0;
};

class GeodesicCache
{
public:
	GeodesicCache(double minCachedPathLength = 0.0, int maxCacheSize = (std::numeric_limits<int>::max)());

	std::shared_ptr<TShortestPath> GetShortestPath(unsigned int beginIndex, unsigned int endIndex, PathComputer& computer);

private:
	std::unordered_map<std::pair<unsigned int, unsigned int>, std::shared_ptr<const TShortestPath>,
		boost::hash<std::pair<unsigned int, unsigned int>>> cache;
	double minCachedPathLength;
	int maxCacheSize;
	wxMutex mutex;

	std::shared_ptr<const TShortestPath> TryGet(unsigned int beginIndex, unsigned int endIndex);
	void TryAdd(unsigned int beginIndex, unsigned int endIndex, std::shared_ptr<const TShortestPath> path);
};
