#include "stdafx.h"

#include "globals.h"

#include "main.h"
#include "luainterface.h"
#include "action.h"
#include "layer.h"
#include "camera2.h"

extern "C" {
    #include <lua.h>
    #include <lauxlib.h>
    #include <lualib.h>
}


TGlobalMediator::TGlobalMediator()
{
	m_lua =  luaL_newstate();
	if(!m_lua) throw string("Couldn't start LUA");
	luaL_openlibs(m_lua);
	m_LuaProgram = new TLuaProgram();

	addLayerSet("default");
}

TGlobalMediator::~TGlobalMediator()
{
	for(unsigned int x=0; x<m_ActionMenus.size(); x++)
	{
		delete m_ActionMenus[x];
	}
	lua_close(m_lua);
	delete m_LuaProgram;
}

void TGlobalMediator::addLayerSet(const string p_Name)
{ 
	shared_ptr<TLayerSet> lm( new TLayerSet(p_Name) );
	m_LayerSets.push_back( lm );
	m_CurrentLayerSet = lm; 
}

shared_ptr<class TSkeletonizer> TGlobalMediator::getSkeletonizer()
{ 
	return getCurrentLayerSet()->m_Skeletonizer; 
}

/*
void TGlobalMediator::addSkeletonizer(shared_ptr<class TSkeletonizer> p_Skeletonizer)
{
	m_SkeletonizerList.push_back( p_Skeletonizer );
	m_Skeletonizer = p_Skeletonizer;

	shared_ptr<TLayerSet> lm( new TLayerSet() );
	m_LayerSet = lm;
	m_LayerSetList.push_back( lm );
}
*/

shared_ptr<TLayer> TGlobalMediator::getCurrentLayer()
{
	return getCurrentLayerSet()->m_CurrentLayer;
}

void TGlobalMediator::setCurrentLayer(TLayer * p_Layer)
{
	for(TLayerSet::TLayerList::iterator it = getCurrentLayerSet()->begin(); it != getCurrentLayerSet()->end(); it++)
	{
		if( (*it).get() == p_Layer ) 
		{
			getCurrentLayerSet()->m_CurrentLayer = *it;
			break;
		}
	}
}


void TGlobalMediator::setCurrentLayer(shared_ptr<TLayer> p_Layer)
{
	getCurrentLayerSet()->m_CurrentLayer = p_Layer;
	MyApp::instance()->setCurrentLayer( p_Layer );
}

void TGlobalMediator::addLayer(shared_ptr<class TLayer> p_Layer)
{
	MyApp::instance()->addLayer(p_Layer);
}

void TGlobalMediator::addLayer(shared_ptr<TLayer> p_Layer, shared_ptr<TLayer> p_AfterLayer)
{
	addLayer(p_Layer,p_AfterLayer.get());
}

void TGlobalMediator::addLayer(shared_ptr<TLayer> p_Layer, class TLayer * p_AfterLayer)
{
	MyApp::instance()->addLayer(p_Layer, p_AfterLayer);
}



void TGlobalMediator::updateUI()
{
	MyApp::instance()->updateUI();
}


void TGlobalMediator::yield()
{
//	MyApp::instance()->Yield();
}

void TGlobalMediator::redrawCanvas()
{
	MyApp::instance()->redrawCanvas();
}

class TGLCanvas * TGlobalMediator::getGLCanvas()
{
	return MyApp::instance()->getGLCanvas();
}

bool TGlobalMediator::isPicking()
{
	return MyApp::instance()->m_Picking;
}

void TGlobalMediator::setRoamingCamera(shared_ptr<TRoamingCamera> p_Camera)
{
	MyApp::instance()->m_RoamingCamera = p_Camera;
	MyApp::instance()->m_CurrentCamera = p_Camera;
}

shared_ptr<class TSskelSegmenter> & TGlobalMediator::getSskelSegmenter()
{
	return MyApp::instance()->m_SskelSegmenter;
}

shared_ptr<class TSskelSegmenter> & TGlobalMediator::getBgSskelSegmenter()
{
	return MyApp::instance()->m_BgSskelSegmenter;
}




TGlobalMediator g_Mediator;
