#ifndef GLOBALS_H
#define GLOBALS_H

#include "stdafx.h"
#include <memory>
using std::shared_ptr;
#include <string>
using std::string;
#include <vector>
using std::vector;

class TGlobalMediator
{
public:
	TGlobalMediator();
	virtual ~TGlobalMediator();


	shared_ptr<class TLayerSet> getCurrentLayerSet() { return m_CurrentLayerSet; }
	shared_ptr<class TLayerSet> getDefaultLayerSet() { return m_LayerSets[0]; }
	void addLayerSet(const string p_Name);
	shared_ptr<class TLayerSet>		m_CurrentLayerSet;
	vector<shared_ptr<class TLayerSet> > m_LayerSets;

	shared_ptr<class TSkeletonizer> getSkeletonizer();
	shared_ptr<class TLayer> getCurrentLayer();
	void addLayer(shared_ptr<class TLayer> p_Layer);
	void addLayer(shared_ptr<TLayer> p_Layer, shared_ptr<TLayer> p_AfterLayer);
	void addLayer(shared_ptr<TLayer> p_Layer, class TLayer * p_AfterLayer);
	void updateUI();
	void setCurrentLayer(shared_ptr<TLayer> p_Layer);
	void setCurrentLayer(TLayer * p_Layer);
	void yield();
	void redrawCanvas();
	class TGLCanvas * getGLCanvas();
	bool isPicking();
	void setRoamingCamera(shared_ptr<class TRoamingCamera> p_Camera);
	shared_ptr<class TSskelSegmenter> & getSskelSegmenter();
	shared_ptr<class TSskelSegmenter> & getBgSskelSegmenter();
	
	void addActionMenu( class TActionMenu * p_ActionMenu )  { m_ActionMenus.push_back( p_ActionMenu ); }

	class TLuaProgram * getLuaProgram() { return m_LuaProgram; }

	struct lua_State* m_lua;
	vector<TActionMenu*> m_ActionMenus;
protected:
	class TLuaProgram * m_LuaProgram;
};

extern TGlobalMediator g_Mediator;

#endif
