#ifndef HISTOGRAM_H
#define HISTOGRAM_H

#include "stdafx.h"
#include <vector>
#include <map>
#include <string>
using std::string;

#include "layer.h"
#include "renderer.h"

class TOpenGLControl
{
public:
	virtual void render() = 0;
};


class TGraph : public TOpenGLControl, public TPickProcessor
{
public:
};


class TScatterPlot  : public TGraph
{
public:
	TScatterPlot();
	virtual void render();
	void add(float x, float y) { m_Points.insert( TMap::value_type(x,y) ); }

protected:
	typedef std::multimap<float, float> TMap;
	TMap m_Points;
	string m_AxisXName;
	shared_ptr<class TColorMap> m_ColorMap;

	virtual void OnPicked(vector<unsigned int> p_PickStack, class wxMouseEvent * event);
};


class THistogram : public TGraph
{
public:
	THistogram();
	virtual void render();
	bool m_Cumulative;
	bool m_LogScale;

protected:
	typedef std::multimap<float, int> TMap;
	TMap m_Points;
	unsigned int m_PointCount;
	string m_AxisXName;
	shared_ptr<class TColorMap> m_ColorMap;
	float m_BinSize;
	int m_SelectedBin;
	unsigned int m_Bins;
	float m_LogBase;

	virtual void OnPicked(vector<unsigned int> p_PickStack, class wxMouseEvent * event);
};

class TLayerHistogram : public THistogram
{
public:
	TLayerHistogram(shared_ptr<TLayer> p_Layer);
	void update(bool p_UseFilter);

	virtual void OnPicked(vector<unsigned int> p_PickStack, class wxMouseEvent * event);
protected:
	shared_ptr<class TLayer> m_Layer;
};



class THistogramMenu : public wxMenu
{
public:
	THistogramMenu(TLayerHistogram * p_LayerHistogram);
	enum
	{
		ID_FIRST
		, ID_CUMULATIVE
		, ID_LOG
		, ID_USEFILTER
		, ID_LAST
	};
	void OnMenuChoice(wxCommandEvent& event);
    DECLARE_EVENT_TABLE()
protected:
	TLayerHistogram * m_LayerHistogram;

	
};


class TSparseGraphField : public TPointerSparseTypedField<THistogram*>
{
public:
	TSparseGraphField(shared_ptr<TIndexMapper> p_IndexField)
		: TPointerSparseTypedField<THistogram*>(p_IndexField)
	{
	}
	virtual ~TSparseGraphField() { clear(); }
	virtual bool needsAdaptor() const { return false; }
	virtual const string getTypeName() { return "graph field"; }
	virtual TType::TYPE getType() const { return TType::TYPE_GRAPH; }
//	virtual void accept(TFieldVisitor * v) { v->visitGraphField(this); }
};

#endif
