#include "stdafx.h"

#include "indexedorigins.h"
#include "field.h"

#include "indexedorigins_cells.h"
#include "indexedorigins_pool.h"

const unsigned int TIndexedOrigins::INVALIDINDEX = (std::numeric_limits<unsigned int>::max)();


/* 
TBoundary::TBoundary(const TIndexMapper * p_IndexField)
	: m_IndexField(p_IndexField)
{
};

unsigned int TBoundary::reverseLookup(const TCoord3 & p_Coord) const
{
	return m_IndexField->vcoord2idx(p_Coord);
}


int TBoundary::getMaxX() const { return m_IndexField->getBaseIndexField()->getMaxX(); }
int TBoundary::getMaxY() const { return m_IndexField->getBaseIndexField()->getMaxY(); }
int TBoundary::getMaxZ() const { return m_IndexField->getBaseIndexField()->getMaxZ(); }
*/

TIndexedOrigins_Vector * TIndexedOrigins::castVector() 
{
	return static_cast<TIndexedOrigins_Vector*>(this);
}

TIndexedOrigins_Set * TIndexedOrigins::castSet() 
{
	return static_cast<TIndexedOrigins_Set*>(this);
}

TIndexedOrigins_Cells * TIndexedOrigins::castCells() 
{
	return static_cast<TIndexedOrigins_Cells*>(this);
}

const TIndexedOrigins_Vector * TIndexedOrigins::castConstVector() const
{
	return static_cast<const TIndexedOrigins_Vector* const>(this);
}

TIndexedOrigins_Multimap * TIndexedOrigins::castMultimap() 
{
	return static_cast<TIndexedOrigins_Multimap*>(this);
}



void TIndexedOrigins_Vector::merge(const TIndexedOrigins_Vector * p_Io)
{
	size_t c = this->vertexcount();
	this->resize(c + p_Io->vertexcount());
	TIndexedOrigins_Vector::const_iterator it;
	for(it = p_Io->begin(); it != p_Io->end(); it++)
	{
		(*this)[c++] = *it;
	}
}

void TIndexedOrigins_Vector::merge(const TIndexedOrigins_Set * p_Io)
{
	size_t c = this->vertexcount();
	this->resize(c + p_Io->vertexcount());
	TIndexedOrigins_Set::const_iterator it;
	for(it = p_Io->begin(); it != p_Io->end(); it++)
	{
		(*this)[c++] = *it;
	}
}

void TIndexedOrigins_Vector::merge(const TIndexedOrigins * p_Io)
{
	size_t c = this->vertexcount();
	this->resize(c + p_Io->vertexcount());
	std::unique_ptr<TIndexedOrigins::TIterator> it( const_cast<TIndexedOrigins*>(p_Io)->newIterator() );
	for(it->init(); it->valid(); it->next())
	{
		(*this)[c++] = it->value();
	}
}

void TIndexedOrigins_Set::merge(const TIndexedOrigins * p_Io)
{
	std::unique_ptr<TIndexedOrigins::TIterator> it( const_cast<TIndexedOrigins*>(p_Io)->newIterator());
	for(it->init(); it->valid(); it->next())
	{
		insert(it->value());
	}
}

void TIndexedOrigins_Set::merge(const TIndexedOrigins_Vector * p_Io)
{
	TIndexedOrigins_Vector::const_iterator it;
	for(it = p_Io->begin(); it != p_Io->end(); it++)
	{
		insert(*it);
	}
}

void TIndexedOrigins_Set::merge(const TIndexedOrigins_Pooled * p_Io)
{
	for(unsigned int * it = p_Io->m_Start; it != p_Io->m_End; it++)
	{
		insert(*it);
	}
}



bool TIndexedOrigins_Set::disjunct(TIndexedOrigins_Set * io)
{
	iterator it = this->begin();
	iterator jt = io->begin();
	bool disjunct = true;
	while(it != this->end() && jt != io->end())
	{
		if(*it == *jt) { disjunct = false; break; }
		else if(*it < *jt) it++;
		else if(*it > *jt) jt++;
	}
	return disjunct;
}



void TIndexedOrigins_Vector::writeToStream(std::ofstream * s) const
{
	unsigned int size = this->size();
	s->write( (char*) &size, sizeof(size) );
	s->write( (char*) &((*this)[0]), sizeof(unsigned int)*this->size() );
}

TIndexedOrigins_Vector * TIndexedOrigins_Vector::readFromStream(std::ifstream * s)
{
	unsigned int size;
	s->read( (char*) &size, sizeof(size) );
	assert(size < 10000);
	TIndexedOrigins_Vector * v = new TIndexedOrigins_Vector();
	if(size > 0)
	{
		v->resize(size);
		s->read( (char*) &((*v)[0]), size*sizeof(unsigned int) );
	}

	return v;
}

