#ifndef INDEXEDORIGINS_H
#define INDEXEDORIGINS_H


#include "stdafx.h"
#include "indexmapper.h"


#include <vector>
using std::vector;
#include <set>
using std::set;
#include <map>
using std::multimap;
#include <iostream>
#include <fstream>
#include <string>
using std::string;

/*
class TBoundary // Wraps around TIndexMapper
{
public:
	TBoundary(const TIndexMapper * p_IndexField);
	unsigned int reverseLookup(const TCoord3 & p_Coord) const;
	inline const TCoord3 & idx2coord(unsigned int idx) const { return m_IndexField->vidx2coord(idx); }
	inline unsigned int size() const { return m_IndexField->getMaxIndex(); }

	int getMaxX() const;
	int getMaxY() const; 
	int getMaxZ() const; 
	const TIndexMapper * m_IndexField;
};
*/


class TIndexedOrigins
{
public:
	enum TYPE { TYPE_VECTOR, TYPE_SET, TYPE_CELLS, TYPE_POOLED, TYPE_MULTIMAP };

	virtual ~TIndexedOrigins() {};

	typedef unsigned int TIndex;
	const static unsigned int INVALIDINDEX;

	virtual class TIndexedOrigins_Vector * castVector();
	virtual const class TIndexedOrigins_Vector * castConstVector() const;
	virtual class TIndexedOrigins_Set * castSet();
	virtual class TIndexedOrigins_Cells * castCells();
	virtual class TIndexedOrigins_Multimap * castMultimap();

	class TIterator
	{
	public:
		virtual ~TIterator() {};
		virtual void init()=0;
		virtual void next()=0;
		virtual bool valid()=0;
		virtual unsigned int value()=0;
	};

	// Pure virtual 
	virtual size_t vertexcount() const = 0;
	virtual TYPE getType() const = 0;
	virtual TIterator * newIterator()=0;

	virtual void writeToStream(std::ofstream * s) const { throw string("TIndexedOrigins::writeToStream() not implemented"); }
	// (non-virtual) static TIndexedOrigins * readFromStream(std::ifstream * s); 
};

;

class TIndexedOrigins_Vector : public TIndexedOrigins, public vector<unsigned int>
{
public:
	TIndexedOrigins_Vector()
		: vector<unsigned int>()
	{}

	TIndexedOrigins_Vector(size_t s)
		: vector<unsigned int>()
	{
		reserve(s);
	}

	TIndexedOrigins_Vector(const set<unsigned int> & p_Set)
	{
		resize(p_Set.size());
		unsigned int x=0;
		for(std::set<unsigned int>::const_iterator it = p_Set.begin(); it != p_Set.end(); it++) (*this)[x++] = *it;
	}
		
	virtual ~TIndexedOrigins_Vector() {};


	inline void add(unsigned int i) { push_back(i); }
	void merge(const TIndexedOrigins_Vector * io);
	void merge(const TIndexedOrigins_Set * p_Io);
	void merge(const TIndexedOrigins * io);
	virtual TYPE getType() const { return TYPE_VECTOR; }
	virtual size_t vertexcount() const { return size(); }


	// Iterator
	class TIterator_Vector : public TIndexedOrigins::TIterator
	{
	public:
		TIterator_Vector(TIndexedOrigins_Vector * p_Io) 
			: TIterator()
			, m_Io(p_Io)
		{
		}
		virtual ~TIterator_Vector() {};

		virtual void init()
		{
			it = m_Io->begin();
		}
		virtual void next()
		{
			it++;
		}
		virtual bool valid()
		{
			return (it != m_Io->end());
		}

		virtual unsigned int value()
		{
			return *it;
		}
	protected:
		TIndexedOrigins_Vector * const m_Io;
		iterator it;
	};
	
	virtual TIterator * newIterator() { return new TIterator_Vector(this); }

	virtual void writeToStream(std::ofstream * s) const;
	static TIndexedOrigins_Vector * readFromStream(std::ifstream * s);
};

class TIndexedOrigins_Set : public TIndexedOrigins, public set<unsigned int>
{
public:
	TIndexedOrigins_Set()
		: m_IsCompact(false)
		, m_ValidIsCompact(true)
	{
	}
	virtual ~TIndexedOrigins_Set() {};


	virtual TYPE getType() const { return TYPE_SET; }
	virtual size_t vertexcount() const { return size(); }
	void merge(const class TIndexedOrigins_Pooled * p_Io);
	void merge(const class TIndexedOrigins_Vector * p_Io);
	void merge(const class TIndexedOrigins * p_Io);

	void add(unsigned int i) { insert(i); }
	bool disjunct(TIndexedOrigins_Set * io);

	// Iterator
	class TIterator_Set : public TIndexedOrigins::TIterator
	{
	public:
		TIterator_Set(TIndexedOrigins_Set * p_Io) 
			: TIterator()
			, m_Io(p_Io)
		{
		}
		virtual ~TIterator_Set() {};

		virtual void init()
		{
			it = m_Io->begin();
		}
		virtual void next()
		{
			it++;
		}
		virtual bool valid()
		{
			return (it != m_Io->end());
		}
		virtual unsigned int value()
		{
			return *it;
		}
	protected:
		TIndexedOrigins_Set * const m_Io;
		iterator it;
	};

	virtual TIterator * newIterator() { return new TIterator_Set(this); }

protected:

	mutable bool m_IsCompact;
	mutable bool m_ValidIsCompact;
};




class TIndexedOrigins_Multimap : public TIndexedOrigins, public std::multimap<float,unsigned int>
{
public:
	virtual ~TIndexedOrigins_Multimap() {};
	
	void merge(const TIndexedOrigins * io);

	inline void add(float v, unsigned int i) { insert( value_type(v,i) ); }
//	void merge(const TIndexedOrigins_Vector * io);
//	void merge(const TIndexedOrigins_Set * p_Io);
//	void merge(const TIndexedOrigins * io);
	virtual TYPE getType() const { return TYPE_MULTIMAP; }
	virtual size_t vertexcount() const { return size(); }


	// Iterator
	class TIterator_Multimap : public TIndexedOrigins::TIterator
	{
	public:
		TIterator_Multimap(TIndexedOrigins_Multimap * p_Io) 
			: TIterator()
			, m_Io(p_Io)
		{
		}
		virtual ~TIterator_Multimap() {};

		virtual void init()
		{
			it = m_Io->begin();
		}
		virtual void next()
		{
			it++;
		}
		virtual bool valid()
		{
			return (it != m_Io->end());
		}

		virtual unsigned int value()
		{
			return it->second;
		}
	protected:
		TIndexedOrigins_Multimap * const m_Io;
		iterator it;
	};
	
	virtual TIterator * newIterator() { return new TIterator_Multimap(this); }

};



#endif

