#ifndef INDEXEDORIGINS_CELLS_H
#define INDEXEDORIGINS_CELLS_H

#include "stdafx.h"
#include "deltaomega.h"
#include "indexedorigins.h"


class TIndexedOrigins_Cells : public TIndexedOrigins, public vector<TDeltaOmega::TCell*>
{
public:
	friend class TIterator_Cells;
	typedef vector<TDeltaOmega::TCell*> TContainerType;

	TIndexedOrigins_Cells()
		: TIndexedOrigins()
		, m_VertexCount(0)
	{}
	virtual ~TIndexedOrigins_Cells() {};




	virtual TYPE getType() const { return TYPE_CELLS; }

	void resize(size_t size)
	{
		vector<TDeltaOmega::TCell*>::resize(size);
		m_VertexCount = 0;
	}

	virtual size_t vertexcount() const
	{ 
		if(m_VertexCount == 0)
		{
			const_iterator kt;
			for(kt=begin(); kt != end(); kt++) m_VertexCount += (*kt)->m_Vertices.size();
		}
		return m_VertexCount;
	}



	inline void add(class TDeltaOmega::TCell * c) 
	{ 
		m_VertexCount=0;
		push_back(c); 
	}



	// Iterator
	class TIterator_Cells : public TIndexedOrigins::TIterator
	{
	public:
		TIterator_Cells(TIndexedOrigins_Cells * p_Io) 
			: TIterator()
			, m_Io(p_Io)
		{
		}
		virtual void init()
		{
			it = m_Io->begin();
			if(it != m_Io->end()) jt = (*it)->m_Vertices.begin();
		}
		virtual void next()
		{
			if(it == m_Io->end()) return;
			jt++;
			if(jt == (*it)->m_Vertices.end() ) 
			{
				it++;
				if(it == m_Io->end()) return;
				jt = (*it)->m_Vertices.begin();
			}
		}
		virtual bool valid()
		{
			return it != m_Io->end();
		}

		virtual unsigned int value()
		{
			return *jt;
		}

	protected:
		TIndexedOrigins_Cells * const m_Io;
		const_iterator it;
		TIndexedOrigins_Vector::const_iterator jt;
	};
	
	virtual TIterator * newIterator() { return new TIterator_Cells(this); }
	
	void mergein(TIndexedOrigins_Vector * p_Io)
	{
		p_Io->reserve( vertexcount() );
		const_iterator it;
		for(it = begin(); it != end(); it++)
		{
			p_Io->merge( &((*it)->m_Vertices) );
		}
	}

protected:
	mutable unsigned int m_VertexCount; 
};


#endif
