#ifndef INDEXEDORIGINS_POOL_H
#define INDEXEDORIGINS_POOL_H

#include "stdafx.h"
#include <string>
using std::string;

#include "indexedorigins.h"

class TIndexedOrigins_Pooled : public TIndexedOrigins
{
public:
	friend class TIOPool;

	TIndexedOrigins_Pooled(unsigned int * p_Start)
		: m_Start(p_Start)
		, m_End(p_Start)
	{
	}
	virtual ~TIndexedOrigins_Pooled()
	{
	};


	inline void add(unsigned int i) 
	{ 
		*(m_End++) = i;
	}

	// virtual TIndexedOrigins implementation
	virtual TYPE getType() const { return TYPE_POOLED; }
	virtual size_t vertexcount() const
	{
		return m_End-m_Start;
	}

	virtual TIterator * newIterator() { return new TIterator_Pooled(this); }

	// Data
	unsigned int * m_Start; // public for fast access without iterator
	unsigned int * m_End;
protected:

	// Iterator
	class TIterator_Pooled : public TIndexedOrigins::TIterator
	{
	public:
		TIterator_Pooled(TIndexedOrigins_Pooled * p_Io) 
			: TIterator()
			, m_Io(p_Io)
		{
		}
		virtual void init()
		{
			it = m_Io->m_Start;
		}
		virtual void next()
		{
			it++;
		}
		virtual bool valid()
		{
			return (it != m_Io->m_End);
		}
		virtual unsigned int value()
		{
			return *it;
		}
	protected:
		const TIndexedOrigins_Pooled * m_Io;
		unsigned int * it;
	};
	
	friend class TIterator_Pooled;
};

class TIOPool
{
public:
	friend TIndexedOrigins_Pooled;

	TIOPool(unsigned int p_MaxObjects);

	// Data
	const size_t m_MaxObjects;
	unsigned int * m_OriginPoolWarning;
	vector<TIndexedOrigins_Pooled>	m_ObjectPool;
	vector<unsigned int>			m_OriginPool;
	unsigned int *					m_StartNew;

	// Members
	inline TIndexedOrigins_Pooled * getNewPooled()
	{
		m_StartNew = m_ObjectPool.back().m_End;
		if(m_StartNew >= m_OriginPoolWarning) throw string("OriginPool too small");
		m_ObjectPool.push_back( TIndexedOrigins_Pooled(m_StartNew) );
		return &m_ObjectPool.back();
	}
};

#endif
