#include "stdafx.h"

#include "indexedoriginsfield.h"

#include "abstractfilter.h"
#include "filter.h"

shared_ptr<TMeasure> TIndexedOriginsField::getDefaultMeasure() { return shared_ptr<TMeasure>(new TIndexedOriginsFieldMeasure_CoordCount(this)); }
shared_ptr<TMeasure> TSparseIOField::getDefaultMeasure() { return shared_ptr<TMeasure>(new TIndexedOriginsFieldMeasure_CoordCount(this)); }
shared_ptr<TMeasure> TSparseIoFieldMultimap::getDefaultMeasure() { return shared_ptr<TMeasure>(new TIndexedOriginsFieldMeasureMultimap_Maximum(this)); }

//shared_ptr<TMeasure> TIndexedOriginsSortedField::getDefaultMeasure() { return shared_ptr<TMeasure>(new TIndexedOriginsSortedFieldMeasure_CoordCount(this)); }


TIndexedOriginsField::TIndexedOriginsField(const TIndexMapper & p_Boundary, int x, int y, int z)
	: TTypedField<TIndexedOrigins*>(x,y,z)
//	, m_Boundary(&p_Boundary)
{
	setEveryValue(0);
}; 

TIndexedOriginsField::~TIndexedOriginsField()
{
	for(unsigned int i=0; i<getMaxX(); i++)
	{
		for(unsigned int j=0; j<getMaxY(); j++)
		{
			for(unsigned int k=0; k<getMaxZ(); k++)
			{
				delete value(i,j,k);
			}
		}
	}
}

void TIndexedOriginsField::writeValueToStream(int i, int j, int k, std::ofstream * s) const
{
//	const TIndexedOrigins * os = value(i,j,k);
//	*s << os->size() << " ";
//	TIndexedOrigins::const_iterator it;
//	for(it = os->begin(); it != os->end(); it++)
//		*s << (*it) << " ";
}
