#ifndef INDEXEDORIGINSGIELD_H
#define INDEXEDORIGINSGIELD_H

#include "stdafx.h"
#include "field.h"
#include "indexedorigins.h"

#include <set>

class TIndexedOriginsField : public TTypedField<class TIndexedOrigins*>
{
public:
	TIndexedOriginsField(const TIndexMapper & p_Boundary, int x, int y, int z = 1);
	virtual ~TIndexedOriginsField();

//	const TBoundary & getBoundary() const { return *m_Boundary; }
//	void setBoundary(TBoundary * p_Boundary) { m_Boundary = p_Boundary; }
	// Read/write
	static TIndexedOriginsField * readFromStream(std::ifstream * s) { return 0; }
	virtual shared_ptr<class TMeasure> getDefaultMeasure();
	virtual void accept(TFieldVisitor * v) { v->visitIndexedOriginsField(this); }
	virtual void writeValueToStream(int i, int j, int k, std::ofstream * s) const;
	virtual const string getTypeName() { return "indexed voxels"; }
	virtual TType::TYPE getType() const { return TType::TYPE_INDEXEDORIGINS; }

protected:
//	const TBoundary * m_Boundary;
};


class TSparseIOField : public TPointerSparseTypedField<class TIndexedOrigins*>
{
public:
	TSparseIOField(shared_ptr<TIndexMapper> p_IndexField, shared_ptr<TIndexMapper> p_IndexToField) 
		: TPointerSparseTypedField<class TIndexedOrigins*>(p_IndexField) 
		, m_IndexToField(p_IndexToField)
	{};
	virtual ~TSparseIOField() { clear(); }
	virtual shared_ptr<class TMeasure> getDefaultMeasure();
	virtual void accept(TFieldVisitor * v) { v->visitIndexedOriginsField(this); }
	virtual const string getTypeName() { return "indexedorigins"; }
	virtual TType::TYPE getType() const { return TType::TYPE_INDEXEDORIGINS; }
	virtual shared_ptr<TIndexMapper> getIndexToField() const { return m_IndexToField; }
	
protected:
	shared_ptr<TIndexMapper> m_IndexToField;
};


class TSparseIoFieldMultimap : public TPointerSparseTypedField<class TIndexedOrigins_Multimap*>
{
public:
	TSparseIoFieldMultimap(shared_ptr<TIndexMapper> p_IndexField, shared_ptr<TIndexMapper> p_IndexToField) 
		: TPointerSparseTypedField<class TIndexedOrigins_Multimap*>(p_IndexField)
		, m_IndexToField(p_IndexToField)
	{};

	virtual ~TSparseIoFieldMultimap() { clear(); }
	virtual shared_ptr<class TMeasure> getDefaultMeasure();
	virtual void accept(TFieldVisitor * v) { v->visitIndexedOriginsMultimapField(this); }
	virtual const string getTypeName() { return "indexedorigins mm"; }
	virtual TType::TYPE getType() const { return TType::TYPE_INDEXEDORIGINS_MULTIMAP; }
	virtual shared_ptr<TIndexMapper> getIndexToField() const { return m_IndexToField; }

protected:
	shared_ptr<TIndexMapper> m_IndexToField;
};


#endif
