#ifndef INDEXMAPPER_H
#define INDEXMAPPER_H

#include "stdafx.h"
#include "coord.h"
#include <iostream>
#include <fstream>
#include <string>

class TIndexMapper 
{
public:
	virtual const TCoord3 & vidx2coord(unsigned int idx) const = 0;
	virtual unsigned int vcoord2idx(const TCoord3 & p) const = 0;
	virtual unsigned int getMaxIndex() const = 0;
	virtual bool vinside(const TCoord3 & p) const { return vcoord2idx(p)!=OUTSIDE; }
	virtual const class TIndexField3 * getBaseIndexField() const = 0;
	const static unsigned int OUTSIDE;
	const static unsigned int BOUNDARY;

	virtual void writeToStream(std::ofstream * s) const { throw std::string("TIndexMapper::writeToStream() not implemented"); }
};


#endif
