#ifndef IVCON_H
#define IVCON_H

#include "stdafx.h"
# include <cstdio>
# include <iomanip>
# include <fstream>
# include <iostream>
using std::ifstream;
# include <vector>
using std::vector;

# define COLOR_MAX 1000
# define COR3_MAX 200000
# define FACE_MAX 200000
# define LINE_MAX_LEN 256
# define LEVEL_MAX 10
# define LINES_MAX 50000
# define MATERIAL_MAX 100
# define ORDER_MAX 10
# define TEXTURE_MAX 100



class TIvCon
{
public:
	TIvCon()
	{
		cor3.resize(3);
		cor3[0].resize( COR3_MAX );
		cor3[1].resize( COR3_MAX );
		cor3[2].resize( COR3_MAX );

		cor3_material.resize(COR3_MAX);

		cor3_normal.resize(3);
		cor3_normal[0].resize( COR3_MAX );
		cor3_normal[1].resize( COR3_MAX );
		cor3_normal[2].resize( COR3_MAX );

		cor3_tex_uv.resize(3);
		cor3_tex_uv[0].resize( COR3_MAX );
		cor3_tex_uv[1].resize( COR3_MAX );
		cor3_tex_uv[2].resize( COR3_MAX );

		face.resize(ORDER_MAX);
		unsigned int x,y;
		for(x=0; x<ORDER_MAX; x++)
		{
			face[x].resize( FACE_MAX );
		}

		face_area.resize(FACE_MAX);
		face_flags.resize(FACE_MAX);
		face_material.resize(FACE_MAX);

		face_normal.resize(3);
		face_normal[0].resize(FACE_MAX);
		face_normal[1].resize(FACE_MAX);
		face_normal[2].resize(FACE_MAX);

		face_object.resize(FACE_MAX);
		face_order.resize(FACE_MAX);
		face_smooth.resize(FACE_MAX);

		face_tex_uv.resize(2);
		face_tex_uv[0].resize( FACE_MAX);
		face_tex_uv[1].resize( FACE_MAX);

		list.resize(COR3_MAX);

		normal_temp.resize(3);
		normal_temp[0].resize( ORDER_MAX*FACE_MAX );
		normal_temp[1].resize( ORDER_MAX*FACE_MAX );
		normal_temp[2].resize( ORDER_MAX*FACE_MAX );

		texture_temp.resize(2);
		texture_temp[0].resize(ORDER_MAX*FACE_MAX );
		texture_temp[1].resize(ORDER_MAX*FACE_MAX );

		//int vertex_material[ORDER_MAX][FACE_MAX];
		vertex_material.resize(ORDER_MAX);
		for(x=0; x<ORDER_MAX; x++) vertex_material[x].resize(FACE_MAX);
		//float  vertex_normal[3][ORDER_MAX][FACE_MAX];
		vertex_normal.resize(3);
		for(x=0; x<3; x++) 
		{
			vertex_normal[x].resize(ORDER_MAX);
			for(y=0; y<ORDER_MAX; y++)
			{
				vertex_normal[x][y].resize(FACE_MAX);
			}
		}

		//float  vertex_rgb[3][ORDER_MAX][FACE_MAX];
		vertex_rgb.resize(3);
		for(x=0; x<3; x++) 
		{
			vertex_rgb[x].resize(ORDER_MAX);
			for(y=0; y<ORDER_MAX; y++)
			{
				vertex_rgb[x][y].resize(FACE_MAX);
			}
		}

		//float  vertex_tex_uv[2][ORDER_MAX][FACE_MAX];
		vertex_tex_uv.resize(2);
		for(x=0; x<2; x++) 
		{
			vertex_tex_uv[x].resize(ORDER_MAX);
			for(y=0; y<ORDER_MAX; y++)
			{
				vertex_tex_uv[x][y].resize(FACE_MAX);
			}
		}
	}

	char anim_name[LINE_MAX_LEN];
	float background_rgb[3];
	int bad_num;
	bool byte_swap;
	int bytes_num;
	int color_num;
	int comment_num;

	//float cor3[3][COR3_MAX];
	vector< vector<float> > cor3;
	//int cor3_material[COR3_MAX];
	vector< int > cor3_material;
	//float cor3_normal[3][COR3_MAX];
	vector< vector<float> > cor3_normal;
	int cor3_num;
	//float cor3_tex_uv[3][COR3_MAX];
	vector< vector<float> > cor3_tex_uv;


	bool debug;

	int dup_num;

	// int face[ORDER_MAX][FACE_MAX];
	vector<vector<int> > face;
	//float  face_area[FACE_MAX];
	vector<float> face_area;
	//int    face_flags[FACE_MAX];
	vector<int> face_flags;
	//int    face_material[FACE_MAX];
	vector<int> face_material;
	//float  face_normal[3][FACE_MAX];
	vector<vector<float> > face_normal;
	int    face_num;
	//int    face_object[FACE_MAX];
	vector<float> face_object;
	// int    face_order[FACE_MAX];
	vector<int> face_order;
	//int    face_smooth[FACE_MAX];
	vector<int> face_smooth;
	//float  face_tex_uv[2][FACE_MAX];
	vector<vector<float> > face_tex_uv;

	char   filein_name[81];
	char   fileout_name[81];

	int    group_num;

	int    i;
	char   input[LINE_MAX_LEN];
	int    k;
	char   level_name[LEVEL_MAX][LINE_MAX_LEN];

	int    line_dex[LINES_MAX];
	int    line_material[LINES_MAX];
	int    line_num;
	int    line_prune;

	//int    list[COR3_MAX];
	vector<int> list;

	char   material_binding[80];
	char   material_name[MATERIAL_MAX][LINE_MAX_LEN];
	int    material_num;
	float  material_rgba[4][MATERIAL_MAX];

	char   mat_name[81];
	int    max_order2;

	char   normal_binding[80];
	//float  normal_temp[3][ORDER_MAX*FACE_MAX];
	vector< vector<float> > normal_temp;

	char   object_name[81];
	int    object_num;

	float  origin[3];
	float  pivot[3];
	float  rgbcolor[3][COLOR_MAX];
	char   temp_name[81];

	int    text_num;

	char texture_binding[80];
	char texture_name[TEXTURE_MAX][LINE_MAX_LEN];
	int texture_num;
	//float texture_temp[2][ORDER_MAX*FACE_MAX];
	vector<vector<float> > texture_temp;

	float transform_matrix[4][4];

	//int vertex_material[ORDER_MAX][FACE_MAX];
	vector<vector<int> > vertex_material;
	//float  vertex_normal[3][ORDER_MAX][FACE_MAX];
	vector<vector<vector<float> > > vertex_normal;
	//float  vertex_rgb[3][ORDER_MAX][FACE_MAX];
	vector<vector<vector<float> > > vertex_rgb;
	//float  vertex_tex_uv[2][ORDER_MAX][FACE_MAX];
	vector<vector<vector<float> > > vertex_tex_uv;



	// Methods
	int command_line ( char **argv );
	int ivcon_main ( int argc, char *argv[] );
	void cor3_normal_set ( void );
	void cor3_range ( void );
	void data_check ( void );
	void data_init ( void );
	bool data_read ( void );
	void data_report ( void );
	int data_write ( void );
	int edge_count ( void );
	float float_read ( FILE *filein );
	int interact ( void );

	void edge_null_delete ( void );
	void face_area_set ( void );
	void face_normal_ave ( void );
	void face_null_delete ( void );
	int face_print ( int iface );
	void face_reverse_order ( void );
	int face_subset ( void );
	void face_to_line ( void );
	void face_to_vertex_material ( void );
	void init_program_data ( void );
	int float_write ( FILE *fileout, float float_val );
	long int long_int_read ( FILE *filein );
	int long_int_write ( FILE *fileout, long int int_val );
	void node_to_vertex_material ( void );
	void vertex_normal_set ( void );
	void vertex_to_node_material ( void );
	void vertex_to_face_material ( void );
	int short_int_write ( FILE *fileout, short int short_int_val );


	int obj_read ( FILE *filein );
	int obj_write ( FILE *fileout );
	int off_read ( ifstream &file_in );
	int off_write ( FILE *fileout );
		
};


//int obj_read ( FILE *filein );
//void init_program_data ();




#endif
