#include "stdafx.h"

#include "logwriter.h"

TLogWriter * g_Log = 0;

#include "wx/string.h"

TLogFileWriter::TLogFileWriter(const string & p_Filename)
{
	m_File = new std::ofstream(p_Filename.c_str());
}

TLogFileWriter::~TLogFileWriter()
{
	delete m_File;
}

TLogWriter & TLogFileWriter::operator<<(int v)
{
	*m_File << v;
	return *this;
}

TLogWriter & TLogFileWriter::operator<<(unsigned int v)
{
	*m_File << wxString::Format("%i",v).c_str();
	return *this;
}

TLogWriter & TLogFileWriter::operator<<(string v)
{
	*m_File << v.c_str();
	return *this;
}

TLogWriter & TLogFileWriter::operator<<(const char v[])
{
	*m_File << v;
	return *this;
}

TLogWriter & TLogFileWriter::operator<<(float v)
{
	*m_File << v;
	return *this;
}

