#ifndef LOGWRITER_H
#define LOGWRITER_H

#include "stdafx.h"
#include <string>
#include <iostream>
#include <fstream>
using std::string;

class TLogWriter
{
public:
	virtual TLogWriter & operator<<(int v) = 0;
	virtual TLogWriter & operator<<(unsigned int v) = 0;
	virtual TLogWriter & operator<<(string v) = 0;
	virtual TLogWriter & operator<<(const char v[]) = 0;
	virtual TLogWriter & operator<<(float v) = 0;
};


class TLogFileWriter : public TLogWriter
{
public:
	TLogFileWriter(const string & p_Filename);
	virtual ~TLogFileWriter();

	virtual TLogWriter & operator<<(int v);
	virtual TLogWriter & operator<<(unsigned int v);
	virtual TLogWriter & operator<<(string v);
	virtual TLogWriter & operator<<(const char v[]);
	virtual TLogWriter & operator<<(float v);
	void flush() { m_File->flush(); }
	std::ofstream * m_File;
};


//#define cout (*MyApp::instance())
extern class TLogWriter * g_Log;


#endif
