#include "stdafx.h"

#include "luainterface.h"

#include "wx/file.h"

extern "C" {
    #include <lua.h>
    #include <lauxlib.h>
    #include <lualib.h>
}


#include "globals.h"
#include "layer.h"
#include "abstractmeasure.h"
#include "wx/ffile.h"
#include "logwriter.h"

/*
static int Lua_GetFieldValue(lua_State *L)
{
	int n = lua_gettop(L);    // Number of arguments
	if(n != 4) 
	{
		lua_pushstring(L, "need 4 arguments");		
		lua_error(L);
	}
	int p_Field = lua_tonumber(L, 1);
	int p_x = lua_tonumber(L, 2);
	int p_y = lua_tonumber(L, 3);
	int p_z = lua_tonumber(L, 4);
	lua_pop(L, 4);
	float result = 0.0f;
	if(g_Mediator.getCurrentLayerSet())
		if(g_Mediator.getCurrentLayerSet()->getLayerById(p_Field))
			if(g_Mediator.getCurrentLayerSet()->getLayerById(p_Field)->m_FilterMeasure)
				result = g_Mediator.getCurrentLayerSet()->getLayerById(p_Field)->m_FilterMeasure->toFloat( TCoord3(p_x,p_y,p_z) );
	lua_pushnumber(L, result);
	return 1;
}
*/

static int Lua_GetFieldValue(lua_State *L)
{
	int n = lua_gettop(L);    // Number of arguments
	if(n != 2) 
	{
		lua_pushstring(L, "need 2 arguments");		
		lua_error(L);
	}
	int p_Field = lua_tonumber(L, 1);
	int p_x = lua_tonumber(L, 2);
	lua_pop(L, 2);
	float result = 0.0f;
	if(g_Mediator.getCurrentLayerSet())
		if(g_Mediator.getCurrentLayerSet()->getLayerById(p_Field))
			if(g_Mediator.getCurrentLayerSet()->getLayerById(p_Field)->m_FilterMeasure)
				result = g_Mediator.getCurrentLayerSet()->getLayerById(p_Field)->m_FilterMeasure->vvaluex(p_x);
	lua_pushnumber(L, result);
	return 1;
}


static int Lua_PrintValue(lua_State *L)
{
	int n = lua_gettop(L);    /* number of arguments */
	if(n != 1) 
	{	
		lua_pushstring(L, "need 1 argument");		
		lua_error(L);
	}
	const char * p_String = lua_tostring(L, 1);
	*g_Log << p_String;
	return 0;
}

static int Lua_PanicFunction(lua_State *L)
{
	lua_pop(L, lua_gettop(L) ); // Empty stack
	throw string("Lua was at panic");
	return 0;
}

void Lua_DoStuff()
{
	lua_State * L = g_Mediator.m_lua;
//	char* strLuaInput = "a = 1 + 1;\nreturn a\n";
//	luaL_dostring(L, strLuaInput);
//	*g_Log << "Test: " << lua_tostring(g_Mediator.m_lua, -1) << "\n";
	lua_pop(L, lua_gettop(L) ); // Empty stack

	lua_register(L, "fv", Lua_GetFieldValue);

	lua_register(L, "printlog", Lua_PrintValue);
//	luaL_dostring(L, "printlog(\"printlog werkt\")\n");
	
//	luaL_dostring(L, "function fcustom(i,x,y,z) return 1 end\n");
	lua_atpanic(L, Lua_PanicFunction);
	
//	*g_Log << "Stack size: " << lua_gettop(L) << "\n";
}

void TLuaProgram::perform()
{
	if(!m_IsDirty) return;
	m_IsDirty = false;

	lua_State * L = g_Mediator.m_lua;
	if(lua_gettop(L) != 0) 
	{
		*g_Log << ("Warning: TLuaProgram::perform(): stack not empty, emptying it\n");
		lua_pop(L, lua_gettop(L) );
	}

	int error = luaL_dostring(L, m_String.c_str());
	if(error)
	{
		string error = lua_tostring(L, -1);
		throw string("TLuaProgram::perform():: LUA error while executing. Error is: '") + error + "'";
	}
}


TLuaProgram::TLuaProgram()
	: m_IsDirty(true)
{
/*
*/
}

TLuaProgram::~TLuaProgram()
{
}

void TLuaProgram::load()
{
	const wxString name = "_luascript.txt";
	if( wxFile::Exists(name) )
	{
		wxFFile f;
		if( f.Open(name) ) 
		{
			*g_Log << "Reading lua script... ";
			wxString str;
			f.ReadAll(&str);
			m_String = str.c_str();
			f.Close();
			*g_Log << "done.\n";
		}
	}
}


void TLuaProgram::save()
{
	if( m_String != "" )
	{
		wxFFile f("_luascript.txt", "w");
		f.Write(m_String.c_str());
		f.Close();
	}
}
