#pragma once

#include "stdafx.h"
#include "wx/glcanvas.h"
#include "wx/propgrid/propgrid.h"
#include "Geometry.h"
#include "voxelset.h"
#include "renderer.h"
#include "logwriter.h"

enum DT_METHOD
{
	METHOD_CDT
	,METHOD_EDT
	,METHOD_MULLIKIN
	,METHOD_FMM
} ;


enum
{
	ID_VOXELSETLISTBOX
	, ID_USEVOXELSET
	, ID_USEFILTER
	, ID_NEWVOXELSETFROMFILTER
	, ID_COLORMAPMEASURESBOX
	, ID_COLORMAPTYPE
	, ID_FILTERMEASURESBOX
	, ID_CREATEVOXELSLICE
	, ID_CREATEORIGSETSElECTION

	, ID_COLORMAPID
	, ID_FILTERID
	, ID_ALLFILTERSBOX
	, ID_ALLCOLORMAPSBOX

	// Menu items
	, ID_MENUFIRST

	, ID_CROP 
	, ID_OPENFIELD
	, ID_SAVEFIELD
	, ID_OPENMODEL
	, ID_CREATEMODEL
	, ID_SAVESCREENSHOT
	, ID_COPYSCREENSHOTTOCLIPBOARD
	, ID_CONVERTMODEL
	, ID_MENU_EXIT
	, ID_OBSERVINGCAMERA
	, ID_ROAMINGCAMERA
	, ID_PERSPECTIVEPROJECTION
	, ID_ORTHOGONALPROJECTION
	, ID_ROTATECAMERA0
	, ID_ROTATECAMERA1
	, ID_ROTATECAMERA2

	, ID_DRAWQUADSFORVOXELS
	, ID_LIGHTING
	, ID_USEBLENDINGFORMODEL
	, ID_FLATSHADING
	, ID_RENDERFOG
	, ID_RENDER2D
	, ID_RENDERCSSELECTIONCOMPONENTS
	, ID_ALLOWPICKINGOFSELECTION
	, ID_OPENCAMERA
	, ID_SAVECAMERA
	, ID_DISPLAYCSHISTOGRAM
	, ID_EDITOBJECTMODE
	, ID_RENDERBLACKANDWHITE
	, ID_NEEDREDRAW2
	, ID_RENDERMODELWITHOUTSHADING
	, ID_PARAMETER_EXTENDCOLLAPSETOLOOPS
	
	, ID_OPENSCALARDATA
	, ID_SKELETONIZESCALARDATA

	, ID_PARAMETER_SEFT_THRESHOLD
	, ID_PARAMETER_DILATION_DISTANCE
	, ID_PARAMETER_CACHE_GEODESICS
	, ID_PARAMETER_USESPATIALSUBDIVISION

	, ID_PARAMETER_EQUALIZESKELETON
	, ID_PARAMETER_KEEPFT
	, ID_PARAMETER_KEEPSHORTESTPATHS
	, ID_PARAMETER_ONLYCSKEL
	, ID_PARAMETER_SPTYPE_DIJKSTRA
	, ID_PARAMETER_SPTYPE_ASTAR
	, ID_PARAMETER_SPTYPE_ALL
	, ID_PARAMETER_COMPUTEIMPORTANCEFORCSKEL
	, ID_PARAMETER_INVERTOBJECT
	, ID_PARAMETER_COMPUTECSKEL
	, ID_PARAMETER_MERGEDEFT
	, ID_PARAMETER_PROCESSPARTLY
	, ID_PARAMETER_SHAPEINFLATION_DISTANCE

	, ID_PARAMETER_SCALE_FACTOR

	, ID_LAYERLISTBOX
	, ID_LAYERSETLISTBOX
	, ID_LOADFIELDBUTTON
	, ID_SAVEFIELDBUTTON
	, ID_EXPORTPOVRAYFIELD
	, ID_EXPORTPOVRAYLAYERSET
	, ID_EXPORTPOVRAYSKELETON
	, ID_EXPORTPOVRAYRECONSTRUCTION
	, ID_EXPORTCURVESKELETONANDJUNCTIONS
	, ID_EXPORTVTK
	, ID_LOADTESTMODEL
	, ID_LOOKDOWNAXIS

	, ID_LOGLINES
	, ID_LUALINES
	, ID_PARSESELECTION


	, ID_SKELETONIZE
	, ID_PARALLEL_SKELETONIZE
	, ID_ROOT_VISUALIZATION

	, ID_ACTION_BEGIN
	, ID_ACTION_END = ID_ACTION_BEGIN + 200


	, ID_DEBUGISLOOP
	, ID_DEBUGISLOOP2
	, ID_DEBUGDILATE2
	, ID_DEBUGSMOOTHSP
	, ID_DEBUGSTABILIZE
	, ID_DEBUGDECOMPOSITION
	, ID_DEBUGBOUNDARIES
	, ID_DEBUGCONNECTPATHS
	, ID_DEBUG_COMPUTEPATHSET
	
	, ID_DT1
	, ID_DT2

	, ID_HELP2
	, ID_ABOUT2
	, ID_RESET

	, ID_MENULAST

};


class MyFrame: public wxFrame
{
public:
    MyFrame(wxFrame *frame, const wxString& title, const wxPoint& pos, const wxSize& size,
        long style = wxDEFAULT_FRAME_STYLE);

    void OnMenuChoice(wxCommandEvent& event);
	void OnMenuOpen(wxMenuEvent& event);

	void OnLayerClick(wxCommandEvent& event);
	void OnLayerSetClick(wxCommandEvent& event);
	void OnLayerCheckListBox(wxCommandEvent& event);
	void OnLayerSetCheckListBox(wxCommandEvent& event);
	void OnLoadField(wxCommandEvent& event);
	void OnSaveField(wxCommandEvent& event);
	void OnCameraChoice(wxCommandEvent& event);
	void OnLookDownAxis(wxCommandEvent& event);
	void OnKeyDown(wxKeyEvent& event);
	void OnNeedRedraw(wxCommandEvent& event);
	void OnParseSelection(wxCommandEvent& event);
	void OnLuaEnterText(wxCommandEvent & event);
	

    void SetCanvas( class TGLCanvas *canvas )    { m_canvas = canvas; }
    class TGLCanvas *GetCanvas()                 { return m_canvas; }
    
private:
    class TGLCanvas*    m_canvas;

    DECLARE_EVENT_TABLE()
};





class TGLCanvas: public wxGLCanvas
{
public:
    TGLCanvas(wxWindow *parent, const wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize, long style = 0, const wxString& name = wxT("TestGLCanvas"), int * attribList = 0);
    ~TGLCanvas(void);

    void OwnPaint();
    void OnPaint(wxPaintEvent& event);
    void OnSize(wxSizeEvent& event);
    void OnEraseBackground(wxEraseEvent& event);
    void OnMouse( wxMouseEvent& event );

	float m_MouseX;
	float m_MouseY;

private:
	float m_PreviousX;
	float m_PreviousY;

	shared_ptr<class TRenderMenu> m_RenderMenu;
	wxGLContext* m_Context;

    DECLARE_EVENT_TABLE()
};




class TLayerListBox  : public wxCheckListBox
{
public:
	TLayerListBox(
				wxWindow *parent, wxWindowID id,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize,
                 int nStrings = 0,
                 const wxString choices[] = NULL,
                 long style = 0,
                 const wxValidator& validator = wxDefaultValidator,
                 const wxString& name = wxListBoxNameStr)
		: wxCheckListBox(parent, id, pos, size, nStrings, choices, style, validator, name )
	{
	};

	void OnMouse(wxMouseEvent & event);
	
    DECLARE_EVENT_TABLE()
};

class TLayerSetListBox  : public wxCheckListBox
{
public:
	TLayerSetListBox(
				wxWindow *parent, wxWindowID id,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize,
                 int nStrings = 0,
                 const wxString choices[] = NULL,
                 long style = 0,
                 const wxValidator& validator = wxDefaultValidator,
                 const wxString& name = wxListBoxNameStr)
		: wxCheckListBox(parent, id, pos, size, nStrings, choices, style, validator, name )
	{
	};

	void OnMouse(wxMouseEvent & event);

    DECLARE_EVENT_TABLE()
};


class TToolPanel : public wxPanel
{
public:
    TToolPanel(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL);

	class TLayerListBox *	m_LayerListBox;
	class TLayerSetListBox *	m_LayerSetListBox;
protected:
	class wxNotebook *		m_Notebook;
	class wxComboBox *		m_ColorMapTypeBox;
	class wxPanel *			m_ColorMapPanel;

	class wxPanel *			m_FilterPanel;
	class wxComboBox *		m_AllFiltersBox;
	class wxComboBox *		m_AllColorMapsBox;
	void OnColorMapTypeSelect(wxCommandEvent& event);
};


class MyApp: public wxApp, public TLogWriter, public TPickProcessor
{
public:
	// Data
//	vector<shared_ptr<TFilter> >	m_Filters;
//	vector<shared_ptr<TColorMap> >  m_ColorMaps;
	int m_VoxelsRendered;
	bool m_RedrawCanvas;
	bool m_Picking;

	// Accessors
	shared_ptr<class TCamera> getCamera() { return m_CurrentCamera; }
	static MyApp * instance()	{ return MyApp::m_Instance; }
	MyFrame * getFrame() { return m_TopWindow; }
	TGLCanvas * getGLCanvas() { return getFrame()->GetCanvas(); }
	void redrawCanvas() 
	{ 
		m_RedrawCanvas = true; 
	}

	// Methods
    bool OnInit(void); // wxApp override
	int OnExit(); // wxApp override
	void InitGL();
	void OnDrawGL();
	void OnMenuChoice(wxCommandEvent& event);
	void OnMenuOpen(wxMenuEvent& event);
	void OnIdle(wxIdleEvent& event);

	void OnLayerClick(wxCommandEvent& event);
	void OnLayerSetClick(wxCommandEvent& event);
	void OnLayerCheckListBox(wxCommandEvent& event);
	void OnLayerSetCheckListBox(wxCommandEvent& event);
	void OnLoadField(wxCommandEvent& event);
	void OnSaveField(wxCommandEvent& event);
	void OnCameraChoice(wxCommandEvent& event);
	void OnLookDownAxis(wxCommandEvent& event);
	void OnCreateVoxelSlice(wxMenuEvent & event);
	void processHits(GLint hits, GLuint buffer[], vector<unsigned int> & p_Hits);

	void updateUI();
	void updateStatusBar();

	virtual void OnPicked(vector<unsigned int> p_PickStack, wxMouseEvent * event);

	class wxTextCtrl *			m_LogLines;
	class wxTextCtrl *			m_LuaLines;

	void addLayer(shared_ptr<TLayer> p_Layer);
	void addLayer(shared_ptr<TLayer> p_Layer, class TLayer * p_AfterLayer);

	virtual TLogWriter & operator<<(int v);
	virtual TLogWriter & operator<<(unsigned int v);
	virtual TLogWriter & operator<<(string v);
	virtual TLogWriter & operator<<(const char v[]);
	virtual TLogWriter & operator<<(float v);


//	shared_ptr<TLayer> getCurrentLayer();
	void setCurrentLayer(shared_ptr<TLayer> p_Layer);
	void attemptPick(wxMouseEvent * event, vector<unsigned int> & p_PickStack);

	string	m_CurrentFile;
	string	m_CurrentMethod;

	void moveSelection(int p_x, int p_y, int p_z);

//	shared_ptr<class TModel>				m_Model;

	shared_ptr<class TCamera>				m_CurrentCamera;
	shared_ptr<class TObservingCamera>	m_ObservingCamera;
	shared_ptr<class TRoamingCamera>		m_RoamingCamera;
//	vector<shared_ptr<TLayer> >		m_Layers;



	// GUI 
	static MyApp *			m_Instance;
	class MyFrame *				m_TopWindow;
	class wxStatusBar *			m_StatusBar;
	class wxRadioBox *			m_RenderModeRadioBox;
	class wxCheckBox *			m_UseVoxelSet;
	class wxPanel *				m_VoxelSetPanel;
	class TToolPanel *			m_ToolPanel;
	class TLayerPanel *			m_LayerPanel;
//	class wxPanel *				m_RightPanel;
	class wxComboBox *			m_LookDownAxisBox;
	class wxRadioButton *			m_ObservingCameraButton;
	class wxRadioButton *			m_RoamingCameraButton;
	class wxMenu *				m_CameraMenu;
	class wxMenuBar *			m_MenuBar;
	class wxMenu *				m_SkeletonizerMenu;

	
	class wxSpinCtrlForInts * 	m_AdvectionStepCount;
	bool					m_AdvectionStop;
	
	// Data
	
	int						m_CubeDisplayList;

	vector<shared_ptr<class TDtComparison> >	m_DtComparisons;
//	shared_ptr<class TSkeletonizer> m_Skeletonizer;
	shared_ptr<class TSskelSegmenter> m_SskelSegmenter;
	shared_ptr<class TSskelSegmenter> m_BgSskelSegmenter;

	vector<TType::TYPE> m_SelectionRendererOrder;
	
	// Methods
	void drawSelection(TLayer * p_Layer);
	void drawLayerSet(class TLayerSet * p_LayerSet);
	void drawBegin();
	void drawEnd();
	void drawVoxelSet(TLayer * p_Layer, TVoxelSet * p_VoxelSet, const TField * p_Field, const TFilter * p_Filter, class TColorMapUsingMeasure * p_ColorMap);
	void drawVoxelSets(vector<TVoxelSet*> & p_VoxelSets, TVoxelSet::VOXELSETTYPE p_Type);
	void drawVoxelSetsInCorrectOrder(vector<TVoxelSet*> & p_VoxelSets);

	void performComparison(const string p_Caption, const TFloatField3 * p_Image, bool p_AddLayer, vector<shared_ptr<TDtComparison> > & p_Comparisons, vector<float> & p_Tolerances, bool p_DoAll = true);
	void processComparisons(vector<shared_ptr<TDtComparison> > & Comparisons, vector<float> & Tolerances);

	void saveScreenshot(string p_Filename);
	void copyScreenshotToClipboard();

protected:
	int MainLoop();	// wxApp override

private:
	void OnSkeletonizeSelected(wxCommandEvent& event);
	void OnVisualizeSelected(wxCommandEvent& event);

	DECLARE_EVENT_TABLE()
};


class TSelectionMenu : public wxMenu
{
public:
	TSelectionMenu();
	enum
	{
		ID_FIRST
		, ID_SELECTIONFROMFILTER
		, ID_SELECTIONFROMFILTERALLLAYERS
		, ID_SELECTIONFROMVISIBLE
		, ID_SELECTIONFROMVISIBLEALLLAYERS
		, ID_CREATEVOXELSLICE
		, ID_DELETEVOXELSET
		, ID_SELECTIONFROMFILTEROTHERLAYER
		
		, ID_MASKBY
		, ID_FIRSTMASKBYLAYER
		, ID_LASTMASKBYLAYER = ID_FIRSTMASKBYLAYER + 100
		
		, ID_SELECTVISIBLE
		, ID_FIRSTSELECTVISIBLE
		, ID_LASTSELECTVISIBLE = ID_FIRSTSELECTVISIBLE + 100
		, ID_LAST
	};
	void OnMenuChoice(wxCommandEvent& event);

    DECLARE_EVENT_TABLE()
};


class TRenderMenu : public wxMenu
{
public:
	TRenderMenu();
	enum
	{
		ID_FIRST
		, ID_CAMERARESET
		, ID_NEEDREDRAW
		, ID_FIELDCHANGED
		, ID_RENDERWHITEBACKGROUND
		, ID_RENDERAXIS
		, ID_RENDERBOUNDARYNORMALS
		, ID_RENDERMODEL
		, ID_RENDERMODELWITHOUTSHADING
		, ID_PREVENTRENDERINGTOOMUCH
		
		, ID_LAST
	};
	void OnMenuChoice(wxCommandEvent& event);

    DECLARE_EVENT_TABLE()
	
};


class TLayerMenu : public wxMenu
{
public:
	TLayerMenu();
	enum
	{
		ID_FIRST
		, ID_UPDATEHISTOGRAMUSINGFILTER
		, ID_UPDATEHISTOGRAM
		, ID_DISABLEHISTOGRAM
		, ID_DELETELAYER
		, ID_SAVEFIELD
		, ID_RENDERCUBES
		, ID_RENDERSPHERES
		, ID_RENDERQUADS
		, ID_RENDERLINES
		, ID_RENDERVOXELOUTLINES
		, ID_RENDERSELECTIONINDICATORS
		, ID_FIRSTADDADAPTOR
		, ID_LASTADDADAPTOR = ID_FIRSTADDADAPTOR + 100
		, ID_ADDSCRIPTEDLAYER
		, ID_RENAMELAYER
		, ID_LAST
	};
	void OnMenuChoice(wxCommandEvent& event);
    DECLARE_EVENT_TABLE()
};

class TLayerSetMenu : public wxMenu
{
public:
	TLayerSetMenu();
	enum
	{
		ID_FIRST
		, ID_SKELETONIZESCALARDATA
		, ID_SAVESKELETON
		, ID_LAST
	};
	void OnMenuChoice(wxCommandEvent& event);
    DECLARE_EVENT_TABLE()
};
