#ifndef TMODEL_H
#define TMODEL_H


//#include <string>
//#include <vector>
//using namespace std;

#include "stdafx.h"
#include <string>
using std::string;
#include <vector>
using std::vector;

#include "Geometry.h"
#include "field.h"

class TModel
{
public:
	TModel(const string & p_Filename, int p_BaseX = 0, int p_Border = 2);
	TModel(TIndexMapper * p_Boundary, TIndexMapper * p_Foreground, int p_Border);
	static TModel * createUsingMarchingCubes(TIndexMapper * p_Boundary, TIndexMapper * p_Foreground, int p_Border);

	void render();

	vector<TPoint3> m_VertexBuffer;
	vector<TVector3> m_Normals;
	vector<unsigned int> m_IndexBuffer;
	vector<TColor3> m_Colors;

//	TPoint3 m_BaseCenter;
	float m_MaxX, m_MaxY, m_MaxZ;
	float m_MinX, m_MinY, m_MinZ;
	float m_Resize;
	int m_Border;
	bool m_UseCulling;
	bool m_DoAxisRotate;
	void computeColorsUsingSegmentation(TTypedFieldInterface<unsigned int>* p_Input);
protected:
	void readPly(const string p_Name);
	TModel();
	void computeMinMax();
};


#endif

