
#ifndef MULLIKIN_H
#define MULLIKIN_H

#include "stdafx.h"
#include "dt.h"
#include "Geometry.h"
#include "field3.h"

class TMullikinDt : public TDt
{
public:
	TMullikinDt(const TFloatField3 * p_Image,  float p_Tolerance, int p_NeighborCount)
		: TDt()
		, m_Image(p_Image)
		, m_Tolerance(p_Tolerance)
		, m_NeighborCount(p_NeighborCount) 
	{
	}

	virtual DT_TYPE getDtType() const { return DT_MCDT; }
	virtual int getNeighborCount() const { return m_NeighborCount; }
	virtual float getTolerance() const { return m_Tolerance; }

	virtual void stageInit();
	virtual void stageMain();
	virtual void stageEnd();

	virtual shared_ptr<TFloatField3> getDistance() const { return m_Distance; };
	virtual shared_ptr<TOrigSetField2> getOrigins() const { return m_Origins; }
	virtual string getLatexName() const;
	virtual string getShortName() const;
	virtual void deleteFields();

protected:
	float m_Tolerance;
	int m_Tolerance2;
	int m_NeighborCount;
	const TFloatField3 * m_Image;
	shared_ptr<TFloatField3> m_Distance;
	shared_ptr<TOrigSetField2> m_Origins;
	shared_ptr<class TFlagField3> m_FlagField;

	int M;
	int N;
	FIELD<TPoint2> * m_SD;

	void test1(const int px, const int py, const int nx, const int ny);
	void test2(const int px, const int py, const int nx, const int ny);

};


#endif
