#pragma once

#include "stdafx.h"

#include "wx/propgrid/propgridiface.h"

#include "field.h"
#include "indexedorigins.h"
#include "deltaomega.h"
#include "shortestpath.h"
#include "geodesiccache.h"

class SkeletonizerThreadContext
{
public:
	SkeletonizerThreadContext(std::shared_ptr<TIndexField3> indexField);

	std::shared_ptr<std::vector<const TIndexedOrigins_Set>> GetExtendedFT();
	std::shared_ptr<const std::vector<const TIndexedOrigins_Set>> GetExtendedFT() const;

	std::shared_ptr<TShortestPathSetField> GetShortestPathSetField();
	std::shared_ptr<const TShortestPathSetField> GetShortestPathSetField() const;

	void AddCurveSkeletonPoint(unsigned int index);
	std::shared_ptr<const TSubIndexMapper> GetCurveSkeletonIndexField() const;

	std::shared_ptr<TSparseFloatField3> GetImportanceMeasureField();
	std::shared_ptr<const TSparseFloatField3> GetImportanceMeasureField() const;

	std::shared_ptr<TSparseFloatField3> GetAngleField();
	std::shared_ptr<const TSparseFloatField3> GetAngleField() const;

	std::shared_ptr<TSparseUintField3> GetLengthField();
	std::shared_ptr<const TSparseUintField3> GetLengthField() const;

	std::shared_ptr<GeodesicCache> GetGeodesicCache();

private:
	std::shared_ptr<TIndexField3> indexField;

	std::shared_ptr<std::vector<const TIndexedOrigins_Set>> extendedFT;
	std::shared_ptr<TShortestPathSetField> shortestPathSetField;
	std::shared_ptr<GeodesicCache> geodesicCache;

	wxMutex curveSkeletonMutex;
	std::shared_ptr<TSubIndexMapper> curveSkeletonIndexField;
	
	std::shared_ptr<TSparseFloatField3> angleField;
	std::shared_ptr<TSparseUintField3> lengthField;
	std::shared_ptr<TSparseFloatField3> importanceMeasureField;
};

class ParallelSkeletonizer
{
public:
	ParallelSkeletonizer(std::string fileName, const wxPropertyGridInterface* properties);

	double GetDilationDistance() const;
	double GetTau() const;
	double GetMaxCosine() const;
	double GetAcceptCosine() const;
	bool ShouldComputeImportance() const;
	bool ShouldComputeAngle() const;

	void Perform();

	std::shared_ptr<const TUnsignedCharField3> GetInputField() const;
	std::shared_ptr<const TIndexField3> GetIndexField() const;
	std::shared_ptr<const TSubIndexMapper> GetBoundaryField() const;

	std::shared_ptr<const std::vector<const TDeltaOmega::TAdjacencyStruct>> GetAdjacencyLists() const;

	std::shared_ptr<const std::vector<const TIndexedOrigins_Vector>> GetFeatureTransform() const;
	std::shared_ptr<const std::vector<const TIndexedOrigins_Set>> GetExtendedFT() const;
	std::shared_ptr<const TShortestPathSetField> GetShortestPathSetField() const;

	std::shared_ptr<const TSubIndexMapper> GetCurveSkeletonIndexField() const;
	std::shared_ptr<const TSparseFloatField3> GetImportanceMeasureField() const;

	std::shared_ptr<const TSparseFloatField3> GetAngleField() const;
	std::shared_ptr<const TSparseUintField3> GetLengthField() const;

private:
	std::string fileName;
	double scale, dilationDistance, tau, maxCosine, acceptCosine;
	int maxThreads, removedVoxels, acceptedVoxels;
	bool computeImportance, computeAngle;

	std::shared_ptr<TUnsignedCharField3> inputField;
	std::shared_ptr<TIndexField3> indexField;
	std::shared_ptr<TSubIndexMapper> boundaryField;

	std::shared_ptr<std::vector<const TDeltaOmega::TAdjacencyStruct>> adjacencyLists;

	std::shared_ptr<std::vector<const TIndexedOrigins_Vector>> featureTransform;
	std::shared_ptr<SkeletonizerThreadContext> context;

	void InitializeFields();
	void SetObjectVoxels();
	void SetBoundaryVoxels();
	void RemoveSurroundedVoxels();
	void IndexVoxels();

	void InitializeAdjacencyLists();
	bool HaveCommonInsideVoxel(const TCoord3& point, const TCoord3& neighbourPoint);

	void ComputeFeatureTransform();
	void ProcessInParallel(int threads);

};
