#include "stdafx.h"

#include "parameters.h"

#include "result.h"

TParameters g_Parameters;

TParameters::TParameters()
	: m_OperationMode(OPERATIONMODE_PRODUCTION)
	, m_CellCount(8)
	, m_GeodesicType(GEODESICTYPE_ASTAR)
	, m_CacheGeodesics(true)
	, m_OptimizeSpatialSubdivision(true)
	, m_MaxFeaturePointCount(1)

	, m_AllPathsToleranceType(ALLPATHSTOLERANCETYPE_ABSOLUTE)
	, m_AllPathsToleranceAbsolute(0.3f)
	, m_AllPathsToleranceRelative(120.0f)
	, m_GeodesicVectorReserveSize(16)
	, m_DilationDistance(5.0f) 
	, m_RobustComponentTau(0.001f)

	, m_MinimumMergedGeodesicsVertexCount(16) // typically 15
	, m_DiscardSmallComponentBoundaries(16) // use 0 for disabling this heuristic, typically 16 

	, m_Debugging(false)
	, m_UseLogFile(false)

	, m_ComputeCskel(true)
	, m_ComputeImportanceForCskel(true)
	, m_OnlyCskelIterative(true)

	, m_KeepShortestPaths(true)
	, m_OnlyKeepShortestPathsOnCskel(false)
	
	, m_KeepFt(false)
	, m_KeepEft(true)
	, m_KeepTotalCollapse(false)
	, m_Equalize(false)
	, m_KeepSeparateGeodesicSet(false)

	, m_ComputeBackgroundSskel(false) 
	, m_UseBoundingBoxForBgFt(true)

	, m_InvertBorder(0)
	, m_SimplifiedEftThreshold(5.0f)

	, m_ProcessObjectPartly(false)

	, m_Segmentation_MinimumSigma(0.75f)
	, m_Segmentation_RhoSimilar(0.6f)
	, m_RemoveSimilarCriticalPoints(true)
	, m_ForceTwoComponentsPerCriticalPoint(true)

	, m_ExtendCollapseToLoops(false)
	, m_ScaleFactor(1)
{

};

void TParameters::acceptStringPairProcessor(TStringPairProcessor * p)
{
	p->add("m_OperationMode", (unsigned int)m_OperationMode);
	p->add("m_CellCount", m_CellCount);
	p->add("m_GeodesicType", (unsigned int)m_GeodesicType);
	p->add("m_CacheGeodesics", (unsigned int)m_CacheGeodesics);
	p->add("m_OptimizeSpatialSubdivision", (unsigned int)m_OptimizeSpatialSubdivision);
	p->add("m_MinimumMergedGeodesicsVertexCount", m_MinimumMergedGeodesicsVertexCount);
	p->add("m_AllPathsToleranceType", (unsigned int)m_AllPathsToleranceType);
	p->add("m_AllPathsToleranceRelative", m_AllPathsToleranceRelative);
	p->add("m_AllPathsToleranceAbsolute", m_AllPathsToleranceAbsolute);
	p->add("m_GeodesicVectorReserveSize", m_GeodesicVectorReserveSize);
	
	p->add("m_KeepEft", (unsigned int) m_KeepEft);
	p->add("m_KeepShortestPaths", (unsigned int) m_KeepShortestPaths);
//	p->add("m_KeepSurfaceCollapse", (unsigned int) m_KeepSurfaceCollapse);
	p->add("m_KeepTotalCollapse", (unsigned int) m_KeepTotalCollapse);

	
}

