#ifndef PARAMETERS_H
#define PARAMETERS_H

#include "stdafx.h"

class TParameters // Settings with regard to the (skeletonization) algorithms
{
public:
	enum TOperationMode { OPERATIONMODE_PRODUCTION, OPERATIONMODE_DEBUG };
	enum TGeodesicType { GEODESICTYPE_DIJKSTRA, GEODESICTYPE_ASTAR, GEODESICTYPE_ALL};
	enum TAllPathsToleranceType { ALLPATHSTOLERANCETYPE_ABSOLUTE,  ALLPATHSTOLERANCETYPE_RELATIVE };

	// Algorithm
	TOperationMode m_OperationMode;
	TGeodesicType m_GeodesicType;
	
	bool m_CacheGeodesics;
	bool m_OptimizeSpatialSubdivision;

	unsigned int m_CellCount;
	unsigned int m_MinimumMergedGeodesicsVertexCount;
	TAllPathsToleranceType m_AllPathsToleranceType;
	float m_AllPathsToleranceAbsolute;
	float m_AllPathsToleranceRelative;
	unsigned int m_GeodesicVectorReserveSize;
	bool m_Equalize;
	bool m_ComputeImportanceForCskel;
	float m_DilationDistance;
	float m_RobustComponentTau;
	unsigned char m_DiscardSmallComponentBoundaries;
	bool m_OnlyCskelIterative;
	bool m_ComputeCskel;
	bool m_UseBoundingBoxForBgFt;
	float m_SimplifiedEftThreshold;
	unsigned int m_MaxFeaturePointCount;
	bool m_ExtendCollapseToLoops;
	double m_ScaleFactor;

	// Administrative  / debugging
	bool m_Debugging;
	bool m_UseLogFile;

	bool m_ProcessObjectPartly;

	bool m_KeepFt;
	bool m_KeepEft;
	bool m_KeepShortestPaths;
	bool m_OnlyKeepShortestPathsOnCskel;
	bool m_KeepTotalCollapse;
	bool m_KeepSeparateGeodesicSet;
	unsigned int m_InvertBorder;

	bool m_ComputeBackgroundSskel;
	bool m_KeepNonPrunedSpSet;
//	float m_MinimumShortestPathLengthForSskel;
//	float m_MiniumEftDistance;


	// Segmentation
	float m_Segmentation_MinimumSigma;
	float m_Segmentation_RhoSimilar;
	bool m_RemoveSimilarCriticalPoints;
	bool m_ForceTwoComponentsPerCriticalPoint;

	// Methods		
	TParameters();
	void acceptStringPairProcessor(class TStringPairProcessor * p);
};

extern TParameters g_Parameters;

#endif
