#ifndef POVRAY_H
#define POVRAY_H

#include "stdafx.h"
#include <string>
using std::string;

class TPovray
{
public:
	TPovray(class TSkeletonizer * p_Skeletonizer);

	virtual void writePovrayField(std::ofstream * p_Stream, const class TLayer * p_Layer, unsigned int p_Id, bool p_IsBlob);
	void writePovraySkeleton(const string & p_OutputFilename, const class TLayer * p_Layer);
	void writePovrayReconstruction(const string & p_OutputFilename, const class TLayer * p_Layer);
	void writePovrayCurveSkeletonAndJunctions(const string & p_OutputFilename);

	void writeLayerSet(const std::string & p_OutputFilename, class TLayerSet * p_LayerSet, class TLayer * p_Layer = 0);

protected:
	class TSkeletonizer * m_Skeletonizer;
};

#endif
