#ifndef RENDERER_H
#define RENDERER_H

#include "stdafx.h"
#include "wx/event.h"

#include "Geometry.h"
#include "field.h"
#include "font.h"
#include <vector>
using std::vector;
#include "voxelset.h"

class TPickProcessor
{
	friend class TGlobalRenderer;
public: 
	virtual void OnPicked(vector<unsigned int> p_PickStack, wxMouseEvent * event) = 0;
protected:
	unsigned int m_PickID;
};

class TGlobalRenderer
{
public:
	TGlobalRenderer();
	static TGlobalRenderer * instance() 
	{ 
		if(!m_GlobalRenderer) m_GlobalRenderer.reset( new TGlobalRenderer() );
		return m_GlobalRenderer.get();
	}
	
	void processPick(vector<unsigned int> p_PickStack, class wxMouseEvent * event);
	void registerMe(TPickProcessor * p_PickProcessor);

	shared_ptr<TFont> m_Font;
	bool m_BlendEquationAvailable;
	 
protected:
	static shared_ptr<TGlobalRenderer> m_GlobalRenderer;
	vector<TPickProcessor*> m_PickProcessors;
};

class TRenderer
{
public:
	TRenderer(const TField * p_Field = 0);
	virtual ~TRenderer();

	void begin();
	void end();
	void renderVoxel(const TCoord3 & c);
	void renderLine(const TCoord3 & from, const TCoord3 & to);
	void renderVector(const TCoord3 & from, const TVector3 & dir);
		
	void setColor(TColor3 & c) 
	{ 
		m_Color = c; 
		glColor3f(m_Color.r, m_Color.g, m_Color.b);
	}

	void setColorByStatus(const class TPath * p_Path, bool p_ForLine = false);

protected:
	const TField * m_Field;
	TGlobalRenderer * m_GR;
	TColor3 m_Color;
	int m_MaxX, m_MaxY, m_MaxZ;
	unsigned char m_Light;
	unsigned char m_DepthTest;
	unsigned char m_CullFace;
	unsigned char m_Blend;
	unsigned char m_PolygonOffsetFill;
	unsigned char m_DepthMask;
	unsigned char m_ColorMaterial;
	int m_BlendEquation;
	GLfloat m_LineWidth;
	bool m_EndCalled;
	bool m_2D;

private:
	GLUquadric* sphereQuadric;
};



class TSelectionRenderer : public TFieldVisitor
{
public:
	TSelectionRenderer();

	virtual void visitFloatField(TTypedFieldInterface<float> * p_Field);
	virtual void visitUintegerField(TTypedFieldInterface<unsigned int> * p_Field);
	virtual void visitUnsignedCharField(TTypedFieldInterface<unsigned char> * p_Field);
	virtual void visitCoord3SetField(TTypedFieldInterface<vector<TCoord3>*> * p_Field);
	virtual void visitCoord3WithFloatSetField(TTypedFieldInterface<vector<pair<TCoord3,float> >*> * p_Field);
	virtual void visitIntegerField(TTypedFieldInterface<int> * p_Field);
	virtual void visitVector2Field(class TVector2Field3 * p_Field);
	virtual void visitIndexedOriginsField(TTypedFieldInterface<class TIndexedOrigins*> *  p_Field);
	virtual void visitIndexedOriginsMultimapField(TTypedFieldInterface<class TIndexedOrigins_Multimap*> *  p_Field);
	virtual void visitShortestPathSetField(TTypedFieldInterface<class TShortestPathSet*> *  p_Field);
	virtual void visitComponentSetField(TTypedFieldInterface<class TComponentSet*> *  p_Field);

	virtual void visitNodeField(TTypedFieldInterface<vector<class TNode*>*> *  p_Field);

	virtual void visitVector3Field(TTypedFieldInterface<TVector3> * p_Field);
};



class TSelectionRenderField_IndexedOrigins : public TSparseUcharField3, public TSelectionObserver
{
public:
	TSelectionRenderField_IndexedOrigins(TVoxelSetSelection * p_Selection, shared_ptr<TIndexMapper> p_IndexField)
		: TSelectionObserver(p_Selection)
		, TSparseUcharField3(p_IndexField)
	{
	};

	virtual void onSelectionChanged();
protected:
};


#endif
