#include "stdafx.h"

#include "result.h"

#include "utils.h"
#include "logwriter.h"


TStringPairProcessor::TStringPairProcessor()
{
	m_Strings.reserve(32);
}

void TStringPairProcessor::add(const string & p_Name, const string & p_Value)
{
	m_Strings.push_back( pair<string,string>(p_Name, p_Value) );
}


void TStringPairProcessor::printToLog()
{
	TStrings::iterator it;
	for(it = m_Strings.begin(); it != m_Strings.end(); it++)
	{
		*g_Log << it->first << ": " << it->second << "\n";
	}
}

string TStringPairProcessor::getPerlHash()
{
	string s;
	s += "{";

	{
		TStrings::iterator it;
		for(it = m_Strings.begin(); it != m_Strings.end(); it++)
		{
			s += "'" + it->first + "'=>'" + it->second + "', ";
		}
	}
	s += "}";
	return s;
}

void TStringPairProcessor::add(const string & p_Name, float p_Value)
{
	m_Strings.push_back( pair<string,string>(p_Name, niceprintfloat(p_Value)) );
}

void TStringPairProcessor::add(const string & p_Name, unsigned int p_Value)
{
	m_Strings.push_back( pair<string,string>(p_Name, niceprintuint(p_Value)) );
}

/*
void TStringPairProcessor::add(const string & p_Name, const SIZE_T p_Value)
{
	m_Strings.push_back( pair<string,string>(p_Name, niceprintuint(p_Value)) );
}
*/

const string TStringPairProcessor::getValue(const string & p_Name)
{
	for(int i=0; i<m_Strings.size(); i++)
	{
		if(m_Strings[i].first == p_Name) return m_Strings[i].second;
	}
	return "";
}







