#include "stdafx.h"

#include "rootwindow.h"

RootWindow::RootWindow(wxWindow* parent)
	: wxDialog(parent, wxID_ANY, "Visualize skeleton", wxDefaultPosition, wxSize(400, 150))
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
	properties = new wxPropertyGrid(this);

	wxFileProperty* fileProperty = new wxFileProperty("Skeleton file", "fileName");
	fileProperty->SetAttribute(wxPG_FILE_WILDCARD, "*.vtk;*.vtk.gz");

	properties->Append(fileProperty);
	properties->Append(new wxIntProperty("Min. component size", "minComponentSize"));
	properties->Append(new wxBoolProperty("Remove junction-connected endPoints",
		"removeJunctionConnectedEndpoints", true));

	sizer->Add(properties, 1, wxEXPAND);
	sizer->Add(CreateButtonSizer(wxOK | wxCANCEL), 0, wxEXPAND);

	this->SetSizer(sizer);
}

std::string RootWindow::GetFileName() const
{
	return properties->GetPropertyValueAsString("fileName").ToStdString();
}

int RootWindow::GetMinComponentSize() const
{
	return properties->GetPropertyValueAsInt("minComponentSize");
}

bool RootWindow::ShouldRemoveJunctionConnectedEndPoints() const
{
	return properties->GetPropertyValueAsBool("removeJunctionConnectedEndpoints");
}

bool RootWindow::ShouldReconnectComponents() const
{
	return properties->GetPropertyValueAsBool("reconnectComponents");
}

SkeletonizeWindow::SkeletonizeWindow(wxWindow* parent)
	: wxDialog(parent, wxID_ANY, "Skeletonize", wxDefaultPosition, wxSize(400, 250))
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
	properties = new wxPropertyGrid(this);

	wxFileProperty* fileProperty = new wxFileProperty("Volume file", "fileName");
	fileProperty->SetAttribute(wxPG_FILE_WILDCARD, "*.vtk;*.vtk.gz;*.scn;*.scn.gz");

	properties->Append(fileProperty);
	properties->Append(new wxFloatProperty("Scale", "scale", 1.0));
	properties->Append(new wxFloatProperty("Dilation distance", "dilationDistance", 5.0));
	properties->Append(new wxBoolProperty("Compute angle", "computeAngle", false));
	properties->Append(new wxBoolProperty("Compute importance", "computeImportance", true));
	properties->Append(new wxFloatProperty("Tau", "tau", 1.0));
	properties->Append(new wxIntProperty("Min. angle", "minAngle", 0));
	properties->Append(new wxIntProperty("Accept angle", "acceptAngle", 180));
	properties->Append(new wxIntProperty("Max. thread count", "maxThreads", wxThread::GetCPUCount()));

	sizer->Add(properties, 1, wxEXPAND);
	sizer->Add(CreateButtonSizer(wxOK | wxCANCEL), 0, wxEXPAND);

	this->SetSizer(sizer);
}

std::string SkeletonizeWindow::GetFileName() const
{
	return properties->GetPropertyValueAsString("fileName").ToStdString();
}

const wxPropertyGridInterface* SkeletonizeWindow::GetProperties() const
{
	return properties;
}