#include "stdafx.h"

#include "scalardata.h"

#include "stdafx.h"
#include "field.h"
#include "globals.h"
#include "layer.h"
#include "skeletonizer.h"

TScalarData::TScalarData(const string p_Filename)
	: m_Filename(p_Filename)
{
	m_SizeX = 120;
	m_SizeY = 100;
	m_SizeZ = 50;

	shared_ptr<TFloatField3> Volume( new TFloatField3(m_SizeX, m_SizeY, m_SizeZ) );
	shared_ptr<TLayer> NewLayer( new TLayer(Volume, "Scalar data", "Scalar data") );
	g_Mediator.getDefaultLayerSet()->insertLayer( NewLayer ); 

	const TCoord3 middle(m_SizeX/2, m_SizeY/2, m_SizeZ/2);
	int x,y,z;
	for(z=0; z<Volume->getMaxZ(); z++)
	for(y=0; y<Volume->getMaxY(); y++)
	for(x=0; x<Volume->getMaxX(); x++)
	{
		const TCoord3 p(x,y,z);
		float vx = fabs((float)(middle.x-x))/(float)m_SizeX;
		float vy = fabs((float)(middle.y-y))/(float)m_SizeY;
		float vz = fabs((float)(middle.z-z))/(float)m_SizeZ; 
		float v = max( max(vx,vy), vz );
		assert(v > -0.001f && v < 1.001f);
		Volume->wvaluep(p) = v;
	}
	Volume->getLayer()->onFieldChanged();
	Volume->getLayer()->m_AllVoxels->setCheckedForRendering(false);
	shared_ptr<TVoxelSet> Multislice( new TVoxelMultiSlice(Volume.get()) );
	Multislice->setCheckedForRendering(true);
	Volume->getLayer()->m_VoxelSets.push_back( Multislice );
	Volume->getLayer()->m_Filter->m_LowerValue = 0.0f;
	Volume->getLayer()->m_Filter->m_UpperValue = 0.25f;
}

void TScalarData::processFilteredVolume(TTypedFieldInterface<float> * p_Volume)
{
	TUnsignedCharField3* LevelSet = new TUnsignedCharField3( p_Volume->getMaxX(), p_Volume->getMaxY(), p_Volume->getMaxZ() );
	unsigned int x,y,z;
	for(z=0; z<p_Volume->getMaxZ(); z++)
	for(y=0; y<p_Volume->getMaxY(); y++)
	for(x=0; x<p_Volume->getMaxX(); x++)
	{
		const TCoord3 p(x,y,z);
		LevelSet->wvaluep(p) = p_Volume->getLayer()->m_Filter->test( p );
	}
	
	TSkeletonizer * skel = new TSkeletonizer( wxString::Format("volume (%.2f, %.2f)", p_Volume->getLayer()->m_Filter->m_LowerValue, p_Volume->getLayer()->m_Filter->m_UpperValue).ToStdString() );
	skel->init( LevelSet );
	skel->perform();
}
