#include "stdafx.h"

#include "scriptedfield.h"

#include "globals.h"
#include "layer.h"
#include "filter.h"

extern "C" {
    #include <lua.h>
    #include <lauxlib.h>
    #include <lualib.h>
}

int TScriptedField::getMaxX() const { return m_IndexField->getBaseIndexField()->getMaxX(); }
int TScriptedField::getMaxY() const { return m_IndexField->getBaseIndexField()->getMaxY(); }
int TScriptedField::getMaxZ() const { return m_IndexField->getBaseIndexField()->getMaxZ(); }

shared_ptr<TMeasure> TScriptedField::getDefaultMeasure() { return shared_ptr<TMeasure>(new TFloatFieldMeasure_Identity(this)); }


TScriptedField::TScriptedField(shared_ptr<TIndexMapper> p_IndexField)
	: m_IndexField(p_IndexField)
	, m_Dummy(0.0f)
	, m_SubjectLayerId(0)
{
};


TScriptedField::~TScriptedField()
{
}

float & TScriptedField::wvaluep(const TCoord3 & p)
{
	throw string("wvaluep not supported");
	return m_Dummy;	
}

const float TScriptedField::vvaluex(unsigned int idx) const
{
	lua_State * L = g_Mediator.m_lua;
	lua_getglobal(L, m_Layer->m_Name.c_str() ); /* function to be called */
	lua_pushnumber(L, idx);                        
	int error = lua_pcall(L, 1, 1, 0);     /* call 'f' with 3 arguments and 1 result */
	float result = 0;
	if(!error) 
	{
		if(lua_isnumber(L, -1))
		{
			result = lua_tonumber(L, -1);
		}
	}
	lua_pop(L,lua_gettop(L));
	return result;
}

const float TScriptedField::vvaluep(const TCoord3 & p) const
{
	if(getIndexField()->vinside(p)) return vvaluex(getIndexField()->vcoord2idx(p));
	else return 0;
/*
	lua_State * L = g_Mediator.m_lua;
	lua_getfield(L, LUA_GLOBALSINDEX, m_Layer->m_Name.c_str() ); 
	lua_pushnumber(L, p.x);                        
	lua_pushnumber(L, p.y);                        
	lua_pushnumber(L, p.z);                        
	int error = lua_pcall(L, 3, 1, 0);     // call 'f' with 3 arguments and 1 result 
	float result = 0;
	if(!error) 
	{
		//string msg = lua_tostring(L, -1);
		//throw string("LUA error when calling: '") + msg + "'";
		if(lua_isnumber(L, -1))
		{
			result = lua_tonumber(L, -1);
		}
	}
	lua_pop(L,lua_gettop(L));
	return result;
*/
}



void TScriptedField::begin()
{
	lua_State * L = g_Mediator.m_lua;
	int error = luaL_dostring(L, wxString::Format("sub = %i\n",m_SubjectLayerId));
	
/*
	lua_State * L = g_Mediator.m_lua;
	if(lua_gettop(L) != 0) 
	{
		*g_Log << ("Warning: TScriptedField::begin(): stack not empty, emptying it\n");
		lua_pop(L, lua_gettop(L) );
	}

	int error = luaL_dostring(L, m_ScriptString.c_str());
	if(error)
	{
		string error = lua_tostring(L, -1);
		throw string("TScriptedField::begin():: LUA error while executing \n"+ m_ScriptString + "\nError is: '") + error + "'";
	}
*/
}

void TScriptedField::DrawGui(class wxWindow * p_Window)
{
//	m_Panel = new TScriptedFieldPanel(this, p_Window, -1, wxPoint(5,5), wxSize(400,600) );
}


TScriptedFieldPanel::TScriptedFieldPanel(TScriptedField * p_Field, wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style)
	: wxPanel(parent, id, pos, size, style)
	, m_Field(p_Field)
{
	{
		wxButton * updatebutton = new wxButton(this, 2, "Update", wxPoint(0,5), wxDefaultSize);
		m_TextCtrl = new wxTextCtrl(this, 0, p_Field->m_ScriptString.c_str(), wxPoint(0, updatebutton->GetSize().GetY()+5), wxSize(300,400), wxTE_MULTILINE ); 
		
//		wxBoxSizer * Sizer = new wxBoxSizer(wxVERTICAL);
//		Sizer->Add(m_TextCtrl , 1, wxALL | wxEXPAND);
//		this->SetSizer( Sizer );

	}
}


void TScriptedFieldPanel::OnEnter(wxCommandEvent & event)
{
	m_Field->m_ScriptString = m_TextCtrl->GetValue().c_str();
}

void TScriptedFieldPanel::OnUpdate(wxCommandEvent & event)
{
	m_Field->m_ScriptString = m_TextCtrl->GetValue().c_str();
	m_Field->getLayer()->onFieldChanged();
}

BEGIN_EVENT_TABLE(TScriptedFieldPanel, wxPanel)
	EVT_TEXT(0, TScriptedFieldPanel::OnEnter)
	EVT_BUTTON(2, TScriptedFieldPanel::OnUpdate)
END_EVENT_TABLE()
