#ifndef SCRIPTEDFIELD_H
#define SCRIPTEDFIELD_H

#include "stdafx.h"
#include "abstractfield.h"
#include "wx/panel.h"


class TScriptedFieldPanel : public wxPanel
{
public:
	TScriptedFieldPanel(class TScriptedField * p_Field, wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL);
	virtual ~TScriptedFieldPanel()
	{
	}
	void OnEnter(wxCommandEvent & event);
	void OnUpdate(wxCommandEvent & event);
	DECLARE_EVENT_TABLE()

protected:
	class wxTextCtrl * m_TextCtrl;
	class TScriptedField * m_Field;
};


class TScriptedField : public TTypedFieldInterface<float>
{
public:
	TScriptedField(shared_ptr<TIndexMapper> p_IndexField);
	virtual ~TScriptedField();
	virtual class TLayer * getLayer() const { return m_Layer; }
	virtual void setLayer(class TLayer * p_Layer) { m_Layer = p_Layer; }

	virtual shared_ptr<class TMeasure> getDefaultMeasure();
	virtual void accept(TFieldVisitor * v) { v->visitFloatField(this); }
	virtual const string getTypeName() { return wxString::Format("scripted field, observing: %i",m_SubjectLayerId).ToStdString(); }
	virtual TType::TYPE getType() const { return TType::TYPE_FLOAT; }

	virtual int getMaxX() const; 
	virtual int getMaxY() const; 
	virtual int getMaxZ() const; 

	virtual float & wvaluep(const TCoord3 & p);
	virtual const float vvaluep(const TCoord3 & p) const;
	virtual const float vvaluex(unsigned int idx) const;
	virtual bool usingIndexField() const { return true; }
	virtual shared_ptr<TIndexMapper> getIndexField() const { return m_IndexField; }

	virtual void begin();
	virtual void DrawGui(class wxWindow *);

	string m_ScriptString;
	unsigned int m_SubjectLayerId;
protected:
	float m_Dummy;
	shared_ptr<TIndexMapper> m_IndexField;
	mutable class TLayer * m_Layer;
	TScriptedFieldPanel * m_Panel;
};



#endif
