#ifndef SKELETONIZER_H
#define SKELETONIZER_H


#include "stdafx.h"
#include "indexedoriginsfield.h"
#include "result.h"
#include "utils.h"
#include "shortestpath.h"
#include "layer.h"
#include "wx/thread.h"

class TSkeletonizerThread : public wxThread
{
public:
	TSkeletonizerThread(unsigned int p_From, unsigned int p_To, TSkeletonizer * p_Skel);
	virtual ~TSkeletonizerThread();
    virtual void OnExit();
    virtual void *Entry();
	void processAllVoxels();

	void processVoxel(const TCoord3 & p, unsigned int Index);
	
private:
	unsigned int m_From, m_To;

	void computeEFT(const TCoord3 & p, TIndexedOrigins_Vector * p_Output, bool p_Symmetrical = false);
	void computePathSet(TShortestPathSet * p_Parameters, const bool p_Debug = false);
//	void dilate(const TCoord3 & p_Coord, const TIndexedOrigins_Vector * p_Input, TIndexedOrigins_Vector * p_Output, bool p_Reset = true);

	unsigned int m_SurfaceCollapseCount;
	float m_GeodesicTime;
	float m_CollapseTime;
	float m_IsLoopTime;
	float m_TimeSpentOnCskelPoints;
	float m_TimeSpentOnOtherPoints;

	TSkeletonizer * m_Skel;
	TPrecisionTimer PrecisionTimer;

	TIndexedOrigins_Vector * EFT;
	TIndexedOrigins_Vector * MergedGeodesics;
	TIndexedOrigins_Cells * SurfaceCollapse;
	TIndexedOrigins_Vector DilatedShortestPaths;
	TTypedFieldInterface<unsigned int> * m_FindConnectedComponentsField;
};

class TSkeletonizer 
{
public:
	// Data
	bool m_Initialized;
	shared_ptr<class TOmega> Omega;
	string m_InputFilename;
	TStringPairProcessor m_Result;
	wxMutex m_Mutex;
	wxMutex m_MutexIsLoop;

	shared_ptr<TIndexField3> m_BaseIndexField; // = m_ForegroundIndexField OR m_BackgroundIndexField
	shared_ptr<TSubIndexMapper> m_BoundaryIndexField;
	shared_ptr<TSubIndexMapper> m_BackgroundBoundaryIndexField;
	shared_ptr<TSubIndexMapper> m_CskelIndexField;
	shared_ptr<TSubIndexMapper> m_ForegroundSskelIndexField;
	shared_ptr<TSubIndexMapper> m_BackgroundSskelIndexField;
	shared_ptr<TSubIndexMapper> m_SskelIndexField; // = m_ForegroundSskelIndexField OR m_BackgroundSskelIndexField
	TTypedFieldInterface<float> * m_ForegroundSurfaceSkeletonField;
	TTypedFieldInterface<float> * m_BackgroundSurfaceSkeletonField;
	TTypedFieldInterface<float> * m_SurfaceSkeletonField; // = m_ForegroundSurfaceSkeletonField OR m_BackgroundSurfaceSkeletonField

	
	shared_ptr<TSparseFloatField3> m_CurveSkeletonField;
	shared_ptr<TSparseTypedField<unsigned char> > m_LoopField; // C-skel detector
	
	
	TTypedFieldInterface<TIndexedOrigins*> * m_EftField;

	shared_ptr<TShortestPathSetField> m_BackgroundSpSetField;
	shared_ptr<TShortestPathSetField> m_ForegroundSpSetField;
	shared_ptr<TShortestPathSetField> m_SpSetField; // = m_BackgroundSpSetField OR m_ForegroundSpSetField


	shared_ptr<TSparseIOField> m_FtField;
	shared_ptr<TSparseIOField> m_TotalCollapseField;


	shared_ptr<TVirtualSparseFloatField_Maximize> m_SkeletonField; // combined C-skel and S-skel measure
	


	shared_ptr<TSparseUcharField3> m_IsLoopHelpFieldUchar;
	shared_ptr<TSparseFloatField3> m_IsLoopHelpFieldFloat;

	float m_NormalizeBy;

	shared_ptr<class TModel> m_Model;

	// Methods
	TSkeletonizer(const string & p_Filename);
	void init(const string & p_Filename);
	void init(TUnsignedCharField3 * Image);
	void perform();

	void addShortestPathSetAdaptorField(TShortestPathSetField* p_Field, const string p_ShortName);
	void addOmegaLayers();

	virtual void writeToFile(const string & p_File);
	static TSkeletonizer * readFromFile(const string & p_File);

	void processAllVoxels();
	void processSmart();

//	TSkeletonizer();

	void inflate(TUnsignedCharField3* Image);
	void removeDisconnectedComponents(TUnsignedCharField3* Image);


	// Data
	TPrecisionTimer m_TotalTimeWithInit;


	bool m_ProcessingBackground;


	// Methods
	bool tryOpenMesh();
	bool tryOpenCamera(const string & Filename);
	void addLayers();

	enum TFieldId
	{
		ID_FG_SSKEL_INDEX = 1,
		ID_FG_SSKEL_SPSET,
		ID_BG_SSKEL_INDEX,
		ID_BG_SSKEL_SPSET, 
		ID_CSKEL_INDEX,
		ID_CSKEL_LOOPFIELD,
		ID_CSKEL_COLLAPSE
	};
};



#endif
