#pragma once

#include "stdafx.h"

#include "parallelskeletonizer.h"

class SkeletonizerThread : public wxThread, public PathComputer
{
public:
	SkeletonizerThread(const ParallelSkeletonizer* skeletonizer, std::shared_ptr<SkeletonizerThreadContext> result, int threadID, int threads);
	
	int GetThreadID() const;

	std::shared_ptr<TShortestPath> ComputeShortestPath(unsigned int a, unsigned int b);

	int GetRemovedVoxels() const;
	int GetAcceptedVoxels() const;

protected:
	ExitCode Entry();

private:
	int threadID, threads;
	int maxArea;
	int removedVoxels, acceptedVoxels;

	const ParallelSkeletonizer* skeletonizer;
	std::shared_ptr<SkeletonizerThreadContext> context;

	std::shared_ptr<const TIndexField3> indexField;
	std::shared_ptr<const TSubIndexMapper> boundaryField;
	std::shared_ptr<const std::vector<const TDeltaOmega::TAdjacencyStruct>> adjacencyLists;
	std::shared_ptr<const std::vector<const TIndexedOrigins_Vector>> featureTransform;

	std::shared_ptr<std::vector<const TIndexedOrigins_Set>> extendedFT;

	std::unordered_map<unsigned int, TDeltaOmega::TAuxiliaryStruct> pathNodes;

	void ProcessVoxel(unsigned int index);

	void ComputeExtendedFT(unsigned int index);

	TShortestPathSet ComputePathSet(unsigned int index);
	std::shared_ptr<TIndexedOrigins_Vector> ReconstructPath(unsigned int endIndex, unsigned int& middleIndex);
	void ComputeTangentPlane(const TCoord3& point, TShortestPath& path) const;

	double ComputeGeodesicCosine(unsigned int index, const TShortestPathSet& shortestPathSet) const;

	TIndexedOrigins_Vector Dilate(const TIndexedOrigins_Vector& mergedGeodesics);
	std::unordered_set<unsigned int> FindEdgeVoxels(const TIndexedOrigins_Vector& dilatedShortestPaths);
	std::vector<unsigned int> CountComponents(const TIndexedOrigins_Vector& dilatedShortestPaths);

	std::vector<int> ComputeComponentAreas(const TIndexedOrigins_Vector& dilatedShortestPaths,
		const std::vector<unsigned int>& components);
	double ComputeImportanceMeasure(std::vector<int>& components);

};
