#include "ssed.h"
#include "stdafx.h"
#include <malloc.h>

#include "wx/string.h"
#include <iostream>
#include <fstream>
#include "logwriter.h"

/*=======================================================================

  Program:  Distance Transforms
  Module:   $Id: ssed.c,v 1.1.1.1 2002/03/22 10:40:02 cuisenai Exp $
  Date:     $Date: 2002/03/22 10:40:02 $
  Language: C
  
  Author:   Olivier Cuisenaire, http://ltswww.epfl.ch/~cuisenai
            
  Descr.: distmapp_4ssed(int *mapp, int n[2]) 

   Takes an image (mapp) of integers of size n[0]*n[1] as input. It 
   computes for all pixels the square of the Euclidean distance to 
   the nearest zero pixel using the 4SSED algorithm. Note that this is
   only an approximation of the Euclidean DT. 

  Reference for the algorithm: 
  
   P.E. Danielsson, "Euclidean distance mappping", Computer Graphics and 
   Image Processing, 14, pp. 227-248, 1980

   F. Leymarie and M.L. Levine, "Fast raster-scan distance propagation on
   the discrete rectangular lattice", CVGIP: Image Understanding, 55, pp. 
   85-94, 1992.
   
  Reference for the implementation:

   Chapter 2 of "Distance transformations: fast algorithms and applications 
   to medical image processing", Olivier Cuisenaire's Ph.D. Thesis, October 
   1999, Universit catholique de Louvain, Belgium.
    
  Terms of Use: 

   You can use/modify this program for any use you wish, provided you cite 
   the above references in any publication that uses it. 
    
  Disclaimer:

   In no event shall the authors or distributors be liable to any party for 
   direct, indirect, special, incidental, or consequential damages arising out 
   of the use of this software, its documentation, or any derivatives thereof, 
   even if the authors have been advised of the possibility of such damage.
   
   The authors and distributors specifically disclaim any warranties, including,
   but not limited to, the implied warranties of merchantability, fitness for a
   particular purpose, and non-infringement.  this software is provided on an 
   "as is" basis, and the authors and distributors have no obligation to provide
   maintenance, support, updates, enhancements, or modifications.
   
=========================================================================*/
 

int distmap_4ssed( int *mapp, int n[2] )
{
	std::ofstream * DebugFile = new std::ofstream("_ssed.txt");
	
	
	/***********************
    IMPORTANT NOTICE: at first we generate a signed EDT, under the form 
    of a array n[0]xn[1] of vectors (dx,dy) coded as two shorts in the
    memory case of an integer in the input image. 

    Later, these two shorts are replaced by the integer value dx*dx+dy*dy

    **********************/

	// Dennie
	int tests = 0;

  int *sq,*dummy;

  int i;
  int nmax,maxi;
  int maxx=n[0]-1; 
  int maxy=n[1]-1;

  int x,y,*pt,*tpt;
  short *dx,*dy,*tdx,*tdy;

  short *ts;
  int *ti;

//  int difx,ok;

 /* initialisation */


  nmax=n[0]; if(nmax<n[1]) nmax=n[1];
  dummy=(int*)calloc(4*nmax+1,sizeof(int)); sq=dummy+2*nmax;
  for(i=2*nmax;i>=0;i--) sq[-i]=sq[i]=i*i;

  ti=&maxi; ts=(short*)ti; *ts=nmax; *(ts+1)=nmax;
  maxi=nmax+256*256*nmax;

  for(y=0,pt=mapp;y<=maxy;y++)
    for(x=0;x<=maxx;x++,pt++) 
      if(*pt!=0) *pt=maxi;
  
  /* compute simple signed DT */

  /* first raster scan */

	for(y=0;y<=maxy;y++)
	{
		pt=mapp+y*n[0];
		for(x=0;x<=maxx;x++,pt++) 
		{
			dx=(short *)pt;
			dy=dx+1;

			if(y>0)
			{
				tpt=pt-n[0];
				tdx=(short *)tpt;
				tdy=tdx+1;
				const int l1 = sq[*dx]+sq[*dy];
				const int l2 = sq[*tdx]+sq[*tdy+1];
				if(l1>l2) { *dx=*tdx; *dy=*tdy+1; }

				*DebugFile << wxString::Format("p(%i,%i) n(%i,%i) l1: %i l2: %i\n", x,y, 0, -1, l1, l2).c_str();
				tests++;
			}

			if(x>0)
			{
				tpt=pt-1;
				tdx=(short *)tpt;
				tdy=tdx+1;
				const int l1 = sq[*dx]+sq[*dy];
				const int l2 = sq[*tdx+1]+sq[*tdy];
				if(l1>l2) { *dx=*tdx+1; *dy=*tdy; }

				*DebugFile << wxString::Format("p(%i,%i) n(%i,%i) l1: %i l2: %i\n", x,y, -1, 0, l1, l2).c_str();
				tests++;
			}
		}

		pt=mapp+y*n[0]+maxx-1;
		for(x=maxx-1;x>=0;x--,pt--) 
		{
			dx=(short *)pt;
			dy=dx+1;

			tpt=pt+1;
			tdx=(short *)tpt;
			tdy=tdx+1;
			const int l1 = sq[*dx]+sq[*dy];
			const int l2 = sq[*tdx-1]+sq[*tdy];
			if(l1>l2) { *dx=*tdx-1; *dy=*tdy; }

			*DebugFile << wxString::Format("p(%i,%i) n(%i,%i) l1: %i l2: %i\n", x,y, 1, 0, l1, l2).c_str();
			tests++;
		}
    }

  /* second raster scan */

  for(y=maxy,pt=mapp+n[0]*n[1]-1;y>=0;y--)
    {
      pt=mapp+n[0]*y+maxx;
      for(x=maxx;x>=0;x--,pt--) 
	{
	  dx=(short *)pt;
	  dy=dx+1;
	  
	  if(y<maxy)
	    {
	      tpt=pt+n[0];
	      tdx=(short *)tpt;
	      tdy=tdx+1;

		  const int l1 = sq[*dx]+sq[*dy];
		  const int l2 = sq[*tdx]+sq[*tdy-1];
	      if(l1>l2) { *dx=*tdx; *dy=*tdy-1; }

			*DebugFile << wxString::Format("p(%i,%i) n(%i,%i) l1: %i l2: %i\n", x,y, 0, 1, l1, l2).c_str();
			tests++;
	    }

	  if(x<maxx)
	    {
	      tpt=pt+1;
	      tdx=(short *)tpt;
	      tdy=tdx+1;
		  const int l1 = sq[*dx]+sq[*dy];
		  const int l2 = sq[*tdx-1]+sq[*tdy];
	      if(l1>l2) { *dx=*tdx-1; *dy=*tdy; }

			*DebugFile << wxString::Format("p(%i,%i) n(%i,%i) l1: %i l2: %i\n", x,y, 1, 0, l1, l2).c_str();
			tests++;
	    }
	}
      pt=mapp+n[0]*y+1;
      for(x=1;x<=maxx;x++,pt++) 
	{
	  dx=(short *)pt;
	  dy=dx+1;
	  
	  tpt=pt-1;
	  tdx=(short *)tpt;
	  tdy=tdx+1;
	  const int l1 = sq[*dx]+sq[*dy];
	  const int l2 = sq[*tdx+1]+sq[*tdy];
	  if(l1>l2) { *dx=*tdx+1; *dy=*tdy; }
		*DebugFile << wxString::Format("p(%i,%i) n(%i,%i) l1: %i l2: %i\n", x,y, -1, 0, l1, l2).c_str();
		tests++;
	}
    }
     
  for(y=0,dx=(short *)mapp,pt=(int *)mapp;y<=maxy;y++)
    for(x=0;x<=maxx;x++,pt++,dx+=2) 
	*pt=sq[*dx]+sq[*(dx+1)];

	*g_Log << "Danielsson tests: " << tests << "\n";
	DebugFile->close();

  return(1);
}






// Todo: implementeren, er is alleen nog maar commentaar bijgezet.

int distmapp_mullikin( int *mapp, int n[2] ) 
// int * mapp: input & output image, output is squared distance
// int n[2]: size of mapp
{
  /***********************
    
    IMPORTANT NOTICE: at first we generate a signed EDT, under the form 
    of a array n[0]xn[1] of vectors (dx,dy) coded as two shorts in the
    memory case of an integer in the input image. 

    Later, these two shorts are replaced by the integer value dx*dx+dy*dy

    **********************/

  int *sq;
  int *dummy;

  int i;
  int nmax,maxi;
  int maxx=n[0]-1; // maxx = maximum x coord
  int maxy=n[1]-1; // maxy = maximum y coord

  int x,y;
  int *pt,*tpt;
  short *dx,*dy,*tdx,*tdy;

  short *ts;
  int *ti;

//  int difx,ok;

 /* initialisation */


  nmax=n[0]; 
  if(nmax<n[1]) nmax=n[1];

  // nmax = maximum of x & y coords
  // { nmax = max(n[0],n[1]) }

  dummy=(int*)calloc(4*nmax+1,sizeof(int)); 
  sq=dummy+2*nmax;
  for(i=2*nmax;i>=0;i--) sq[-i]=sq[i]=i*i;
  // { sq[i] = i^2 (lookup table) }


  ti=&maxi; 
  ts=(short*)ti; 
  *ts=nmax; 
  *(ts+1)=nmax;
  maxi=nmax+256*256*nmax;

  // Initialize nonzero points in mapp to vectors
  for(y=0,pt=mapp;y<=maxy;y++)
    for(x=0;x<=maxx;x++,pt++) 
      if(*pt!=0) *pt=maxi;
  
  /* compute simple signed DT */

  /* first raster scan */

	for(y=0;y<=maxy;y++)
	{
		pt=mapp+y*n[0];
		// { int *pt points to vector at begin of row: (0,y)
		for(x=0;x<=maxx;x++,pt++) 
		{
			// { int *pt points to integer (x,y) in mapp in which two shorts make up the vector }
			dx=(short *)pt; 
			dy=dx+1;
			// { dx = x coord of *pt, dy = y coord of *pt }

			if(y>0)
			{
				tpt=pt-n[0];
				// { tpt points to vector in previous row (x,y-1)
				tdx=(short *)tpt;
				tdy=tdx+1;
				// { tdx = x coord of *tpt, tdy = y coord of *tpt }
				if(sq[*dx]+sq[*dy] > sq[*tdx]+sq[*tdy+1]) 
				{ 
					// { dx*dx + dy*dy > tdx*tdx + tdy*tdy > 
					*dx=*tdx; 
					*dy=*tdy+1; 
				}
			}

			if(x>0)
			{
				tpt=pt-1;
				tdx=(short *)tpt;
				tdy=tdx+1;
				if(sq[*dx]+sq[*dy]>sq[*tdx+1]+sq[*tdy]) 
				{ 
					*dx=*tdx+1; 
					*dy=*tdy; 
				}
			}
		}

		pt=mapp+y*n[0]+maxx-1;
		for(x=maxx-1;x>=0;x--,pt--) 
		{
			dx=(short *)pt;
			dy=dx+1;

			tpt=pt+1;
			tdx=(short *)tpt;
			tdy=tdx+1;
			if(sq[*dx]+sq[*dy]>sq[*tdx-1]+sq[*tdy]) { *dx=*tdx-1; *dy=*tdy; }
		}
    }

  /* second raster scan */

  for(y=maxy,pt=mapp+n[0]*n[1]-1;y>=0;y--)
    {
      pt=mapp+n[0]*y+maxx;
      for(x=maxx;x>=0;x--,pt--) 
	{
	  dx=(short *)pt;
	  dy=dx+1;
	  
	  if(y<maxy)
	    {
	      tpt=pt+n[0];
	      tdx=(short *)tpt;
	      tdy=tdx+1;
	      if(sq[*dx]+sq[*dy]>sq[*tdx]+sq[*tdy-1]) { *dx=*tdx; *dy=*tdy-1; }
	    }

	  if(x<maxx)
	    {
	      tpt=pt+1;
	      tdx=(short *)tpt;
	      tdy=tdx+1;
	      if(sq[*dx]+sq[*dy]>sq[*tdx-1]+sq[*tdy]) { *dx=*tdx-1; *dy=*tdy; }
	    }
	}
      pt=mapp+n[0]*y+1;
      for(x=1;x<=maxx;x++,pt++) 
	{
	  dx=(short *)pt;
	  dy=dx+1;
	  
	  tpt=pt-1;
	  tdx=(short *)tpt;
	  tdy=tdx+1;
	  if(sq[*dx]+sq[*dy]>sq[*tdx+1]+sq[*tdy]) { *dx=*tdx+1; *dy=*tdy; }
	}
    }
     
  for(y=0,dx=(short *)mapp,pt=(int *)mapp;y<=maxy;y++)
    for(x=0;x<=maxx;x++,pt++,dx+=2) 
	*pt=sq[*dx]+sq[*(dx+1)];

  return(1);
}

