#ifndef SSKELSEGMENTATION_H
#define SSKELSEGMENTATION_H

#include "stdafx.h"
#include "abstractfilter.h"
#include "action.h"
#include <memory>
using std::shared_ptr;

#include <limits>
#include <set>
using std::set;
#include <map>
using std::map;
#include <vector>
using std::vector;

#include "abstractmeasure.h"
#include "field.h"
#include "filter.h"

class TEdge
{
public:
	TEdge(unsigned int p_From, unsigned int p_To, bool p_6Neighbor) 
		: m_From(p_From), m_To(p_To) 
		, m_6Neighbor(p_6Neighbor)
	{
//		if(p_From >= p_To) throw string("p_From >= p_To");
	}

	unsigned int m_From;
	unsigned int m_To;
	bool m_6Neighbor;
	
	float m_Distance;
	float m_SimilarityGeoFp;
	float m_SimilarityTp;
};

class TNode 
{
public:
	TNode(unsigned int p_Index, TCoord3 p) 
	: m_Index(p_Index)
	, m_Coord(p)
	, m_SegmentId(0)

	// For sp computation
	, m_IsKnown(false)
	, m_Distance((std::numeric_limits<float>::max)())
	, m_Previous(0)
	{};

	unsigned int m_Index;
	TCoord3 m_Coord;
	shared_ptr<class TShortestPath> m_ShortestPath;
	vector<shared_ptr<class TShortestPath> > m_ShortestPaths;
	
	vector< unsigned int > m_Neighbors;
	vector< TEdge* > m_Edges;

	shared_ptr<class TIndexedOrigins_Vector> m_Eft;
	unsigned int m_SegmentId;
	
	bool m_IsKnown;
	float m_Distance;
	TNode * m_Previous;
};


class TNodeComponent
{
public:
	vector<TNode*> m_Nodes;
	unsigned int m_Index;
	set<unsigned int> m_Neighbors;
	typedef map<unsigned int, float> TMaximumDistanceTo;
	TMaximumDistanceTo m_MaximumDistanceTo;
	float m_Importance;
};

class TSskelSegment : public TNodeComponent
{
public:
	TSskelSegment()
		: m_MinimumImportance( (std::numeric_limits<float>::max)() )
		, m_MaximumImportance(0)
		, m_MinColor(0)
	{}; 
	float m_MinimumImportance;
	float m_MaximumImportance;
	float m_MaximumDissimilarity;
	typedef map<float, TEdge*, std::greater<float> > TDissimilarEdges;
	TDissimilarEdges m_DissimilarEdges;
	unsigned int m_MinColor;

	bool needsRefinement();

};

class TNodeGraph
{
public:
	vector<TNode> m_Nodes;
	vector<shared_ptr<TEdge> > m_Edges;
	vector<TSskelSegment > m_Segments;
	void initializeGraph(TTypedFieldInterface<TShortestPathSet*> * SPSF, const string p_Name);
	void initializeIntCurveGraph(TTypedFieldInterface<TShortestPathSet*> * SPSF, string p_Name);

	TTypedFieldInterface<vector<TNode*>*>* m_NodeField;
	vector<unsigned int>			m_Visited;
	unsigned int					m_vc;

	void getSeeds(vector<TNode*> *p_Output, float p_Threshold);
//	void getSeeds(const TTypedFieldInterface<TShortestPathSet*> * SPSF, vector<TNode*> *p_Output);
	void getSeedsUsing2Criterion(vector<TNode*> *p_Output, float p_Threshold);

	void extend(const vector<TNode*>* p_Input, vector<TNode*> *p_Output, float p_Threshold);
	TTypedFieldInterface<unsigned int>* outputNodes(const vector<TNode*>* p_Input, string p_Name);

	void dilate(const vector<TNode*> * p_Input, vector<TNode*> * p_Output, float p_Distance);
	void dilate2x2(const vector<TNode*> * p_Input, vector<TNode*> * p_Output);
	void reset();
	void resetSegmentIds();
	void floodfill(const TTypedFieldInterface<unsigned int> * p_Input);
	void computeSegmentStats();
	void printSegmentStats();
//	float areNeighbors(TEdge * p_Edge);
	void outputSegmentationMinColoring(const string & p_Name);
	void pruneSegments(unsigned int p_Threshold, unsigned int p_ToId);
	void outputSegmentation(const string & p_Name);
	void outputEverySegment();
	void convertToThisGraph(const vector<TNode*> *p_Input, vector<TNode*> *p_Output);
	void removeSegment(unsigned int p_SegmentId);

	void checkForResetError();
	virtual void computeSpecificSegmentStats() {};
};

class TYNetwork : public TNodeGraph
{
public:
//	void computeYCurveComponents(float p_Threshold, vector<TNode*> * p_Output, string p_Name);
	void computeYCurveComponents(float, float, vector<TNode*> * p_Output, string p_Name);
	virtual void computeSpecificSegmentStats();
};

class TSskelGraph : public TNodeGraph
{
public:
	bool areNeighbors(TEdge * p_Edge, TYNetwork * p_Network);
	void floodfillUsingAreNeighbors(TYNetwork * p_Network);
	float computePath(TNode * p_From, TNode * p_To, bool p_UseAreNeighbors, vector<TNode*> * p_Path, TYNetwork * p_Network);
	
	void unifyLocalSheetNormals();
};

class TSskelSegmenter 
{
public:
	float WEIGHTS[3];

	TSskelSegmenter();
	virtual ~TSskelSegmenter()
	{
	}

	TSskelGraph m_SskelGraph;
	TYNetwork m_IntCurveGraph;

	static string getStaticName() { return "S-skel segm."; }


	bool m_RemoveDilatedYCurve;


	void outputSegmentationField(const string & p_Name);
};



class TSskelNodeFieldMeasure : public TMeasure
{
public:
	TSskelNodeFieldMeasure(TTypedFieldInterface<vector<TNode*> *> * p_Field) 
		: m_Field(p_Field), TMeasure(p_Field) {};
	virtual TType::TYPE getSourceType() const { return TType::TYPE_NODE; }
protected:
	TTypedFieldInterface<vector<TNode*> *> * m_Field;
};

class TSskelNodeFieldMeasure_Count : public TSskelNodeFieldMeasure
{
public:
	TSskelNodeFieldMeasure_Count(TTypedFieldInterface<vector<TNode*> *> * p_Field) 
		: TSskelNodeFieldMeasure(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p) ? m_Field->vvaluep(p)->size() : 0.0f; }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x) ? m_Field->vvaluex(x)->size() : 0.0f; }
	virtual string getName() const { return "count"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_NODE_COUNT; }
	virtual TMeasure * create(TField * p_Field) const { return new TSskelNodeFieldMeasure_Count(static_cast<TTypedFieldInterface<vector<TNode*> *>*>(p_Field)); }
};

class TSskelNodeField : public TPointerSparseTypedField<vector<TNode*>* >
{
public:
	TSskelNodeField(shared_ptr<TIndexMapper> p_IndexField)
		: TPointerSparseTypedField<vector<TNode*> *>(p_IndexField)
	{
	}
	virtual ~TSskelNodeField() 
	{ 
		clear(); 
	}
	virtual const string getTypeName() { return "node field"; }
	virtual TType::TYPE getType() const { return TType::TYPE_NODE; }
	virtual void accept(TFieldVisitor * v) { v->visitNodeField(this); }
	virtual shared_ptr<TMeasure> getDefaultMeasure() { return shared_ptr<TMeasure>( new TSskelNodeFieldMeasure_Count(this) ); }

};


class TAction_ShowDissimilarities : public TAction
{
public:
	virtual string getName() { return getStaticName(); }
	static string getStaticName() { return "Filter junctions"; }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};




/*
class TAction_SskelSegmenterUsingConnectedComponents : public TAction
{
public:
	virtual string getName() { return getStaticName(); }
	static string getStaticName() { return "Segment S-skel using conn. comp."; }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_SskelSegmenterUsingIntCurves : public TAction
{
public:
	virtual string getName() { return getStaticName(); }
	static string getStaticName() { return "Segment S-skel using int. curves."; }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};
*/


class TAction_SkeletonizeForSskelSegmentation : public TAction
{
public:
	static string getStaticName() { return "Skeletonize for S-skel segmentation"; }
	virtual string getName() { return getStaticName(); }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	virtual void perform_init();
	string m_Filename;
};

class TAction_ComputePathAndDebug : public TAction
{
public:
	virtual string getName() { return getStaticName(); }
	static string getStaticName() { return "Compute path and show debugging info"; }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_Debug_SameIntCurves : public TAction
{
public:
	virtual string getName() { return getStaticName(); }
	static string getStaticName() { return "Debug: are 2 voxels on same int curve"; }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


/*
class TAction_SegmentWithIntCurves : public TAction
{
public:
	static string getStaticName() { return "S-skel segmentation with int. curves"; }
	virtual string getName() { return getStaticName(); }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};
*/


class TAction_PruneSpSetByGeoFpDistanceForSskelSegmentation : public TAction
{
public:
	TAction_PruneSpSetByGeoFpDistanceForSskelSegmentation()
		: m_SPSF(0)
		, m_Filter(0)
	{
	}

	static string getStaticName() { return "Pruned sp set"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	string m_ShortName;
	static TShortestPathSet *  process(TShortestPathSet * sps, float p_LowerValue);
	TTypedFieldInterface<TShortestPathSet*> * m_SPSF;
	TFloatFilter * m_Filter;
protected:
	virtual void perform_main();
};


class TAction_SskelSegmenterUsingIntCurvesConnectedComponents : public TAction
{
public:
	TAction_SskelSegmenterUsingIntCurvesConnectedComponents()
		: m_FgBg(true)
	{
	}
	static string getStaticName() { return "Segment using int curv con comp"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	static bool sameIntCurves(const TShortestPathSet * sps, const TShortestPathSet * nsps, float p_MaximumTolerance, bool p_Debug = false);
	static bool sameIntCurvesNodes(const TNode * n1, const TNode * n2, float p_MaximumTolerance, bool p_Debug = false);
	bool m_FgBg;
protected:
	virtual void perform_main();
	void renumber(TTypedFieldInterface<unsigned int> * p_Cluster);

};


class TAction_SegmentSskel : public TAction
{
public:
	static string getStaticName() { return "Segment S-skel"; }
	virtual string getName() { return getStaticName(); }

	virtual string getScreenName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable() { return true; }
protected:
	virtual void perform_main();
};



#endif

