#pragma once

#include "stdafx.h"

#include "abstractfield.h"


void utilDrawAxes();
void utilDrawCube();
void utilDrawQuad();
void utilDrawCubeSide(int p_Side);

void checkGlError();


string floattostring(float v);
string uinttostring(unsigned long v);

string niceprintfloat(float v);
string niceprintuint(unsigned long v);

const PROCESS_MEMORY_COUNTERS & getProcessInfo();


class TPrecisionTimer
{
public:
	TPrecisionTimer()
	{
		QueryPerformanceFrequency(&lFreq);
	}

	inline void start()
	{
		QueryPerformanceCounter(&lStart);
	}

	inline float stop()
	{
		// Return duration in seconds...
		LARGE_INTEGER lEnd;
		QueryPerformanceCounter(&lEnd);
		return (float)(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
	}

protected:
	LARGE_INTEGER lFreq, lStart;
};



class 	GeomUtils
	{
	public:
	
	static float	normal(float* v1,float* v2,float* v3,float* n);
	static void	normalDirection(float* v1,float* v2,float* v3,float* n);
	static void	cross(float* v1,float* v2,float* res);
	static void	cross(float* p1,float* p2,float* p3,float* res);
	static void	grad_bf(int,float*,float*,float*,float,float*,float*);
	static float	grad_prod(int,float*,float*,float*,float);
	static float	distance2(float*,float*);
	static float    dot(const float*,const float*);
	static float    area(float*,float*,float*);
	static void	barycenter(float*,float*,float*,float* result);
	static void     moment1(float*,float*,float*,float* result);	//result[] = M1[0,0]..M1[2,2], upper-half of M1[] matrix, M1=avg-1st-moment
	static int      JacobiN(float **a, int n, float *w, float **v);	// w = eigenvalues, v = eigenvectors of matrix a[n][n]
	static int      JacobiN(double **a,int n, double *w,double **v);// w = eigenvalues, v = eigenvectors of matrix a[n][n]
	static float	normalize(float*);				//normalize arg, return original length
	static float	norm(float*);					//return norm of arg
	static void	mult(float*,float);				// arg1[] *= arg2
        static float    planeEvaluate(float* norm,float* orig,float* x); //evaluate plane eqn determined by normal,orig,point
	};
	

	
inline void GeomUtils::normalDirection(float* v1,float* v2,float* v3,float* n)
{
   float ax, ay, az, bx, by, bz;
   
   // order is important. maintain consistency with triangle vertex order
   ax = v3[0] - v2[0]; ay = v3[1] - v2[1]; az = v3[2] - v2[2];
   bx = v1[0] - v2[0]; by = v1[1] - v2[1]; bz = v1[2] - v2[2];
	     
   n[0] = (ay * bz - az * by);
   n[1] = (az * bx - ax * bz);
   n[2] = (ax * by - ay * bx);
}

inline void GeomUtils::cross(float* a,float* b,float* res)
{
   res[0] = (a[1] * b[2] - a[2] * b[1]);
   res[1] = (a[2] * b[0] - a[0] * b[2]);
   res[2] = (a[0] * b[1] - a[1] * b[0]);
}

inline void GeomUtils::cross(float* p1,float* p2,float* p3,float* res)
{
   float v1[3],v2[3];
   v1[0] = p2[0]-p1[0]; v1[1] = p2[1]-p1[1]; v1[2] = p2[2]-p1[2]; 
   v2[0] = p3[0]-p1[0]; v2[1] = p3[1]-p1[1]; v2[2] = p3[2]-p1[2];     
   cross(v1,v2,res);
}

		


	
inline float GeomUtils::normal(float* v1,float* v2,float* v3,float* n)
{
   float ax, ay, az, bx, by, bz;
   
   // order is important. maintain consistency with triangle vertex order
   ax = v3[0] - v2[0]; ay = v3[1] - v2[1]; az = v3[2] - v2[2];
   bx = v1[0] - v2[0]; by = v1[1] - v2[1]; bz = v1[2] - v2[2];
	     
   n[0] = (ay * bz - az * by);
   n[1] = (az * bx - ax * bz);
   n[2] = (ax * by - ay * bx);

   float l = GeomUtils::normalize(n);
   return l/2;						//return area of v1v2v3
}





inline void GeomUtils::moment1(float* p1, float* p2, float* p3, float* m)
{
  float w1[3],w2[3],w3[3];
    
  w1[0] = (p1[0]+p2[0])/2;  w1[1] = (p1[1]+p2[1])/2; w1[2] = (p1[2]+p2[2])/2; 
  w2[0] = (p2[0]+p3[0])/2;  w2[1] = (p2[1]+p3[1])/2; w2[2] = (p2[2]+p3[2])/2; 
  w3[0] = (p1[0]+p3[0])/2;  w3[1] = (p1[1]+p3[1])/2; w3[2] = (p1[2]+p3[2])/2; 

  float a = 1.0f/3.0f;
  
  m[0] = a*(w1[0]*w1[0] + w2[0]*w2[0] + w3[0]*w3[0]);			//M[0,0] 
  m[1] = a*(w1[0]*w1[1] + w2[0]*w2[1] + w3[0]*w3[1]);			//M[0,1]
  m[2] = a*(w1[0]*w1[2] + w2[0]*w2[2] + w3[0]*w3[2]);			//M[0,2]
  m[3] = a*(w1[1]*w1[1] + w2[1]*w2[1] + w3[1]*w3[1]);			//M[1,1]
  m[4] = a*(w1[1]*w1[2] + w2[1]*w2[2] + w3[1]*w3[2]);			//M[1,2]
  m[5] = a*(w1[2]*w1[2] + w2[2]*w2[2] + w3[2]*w3[2]);			//M[2,2] 
}
                                           
inline float GeomUtils::distance2(float* a,float* b)
{
  return (a[0]-b[0])*(a[0]-b[0])+(a[1]-b[1])*(a[1]-b[1])+(a[2]-b[2])*(a[2]-b[2]);
}

inline float GeomUtils::planeEvaluate(float* normal, float* origin, float* x)
{
  return normal[0]*(x[0]-origin[0]) + normal[1]*(x[1]-origin[1]) + 
         normal[2]*(x[2]-origin[2]);
}


int JacobiN(float **a, int n, float *w, float **v);

void PCA2(const class TIndexedOrigins_Vector * p_Io, float* norm, float* u1, float* u2, float* barycenter);


void CopyScreenshotToClipboard(class wxGLCanvas * p_Canvas);
void SaveScreenshot(class wxGLCanvas * p_Canvas, string p_Filename);



void createColoring(const TTypedFieldInterface<unsigned int> * p_Input, int p_ComponentCount, string p_Name);


void decompressZlib(const string& inputFile, const string& outputFile);

void decompressAndWait(const string & p_File);
void compressAndWait(const string & p_File);
