#ifndef VOLUMESEGMENTATION_H
#define VOLUMESEGMENTATION_H

#include "stdafx.h"
#include "action.h"
#include <set>

class TAction_VolumeSegmentationSkeletonize : public TAction
{
public:
	virtual string getName() { return "Skeletonize for volume segmentation"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	virtual void perform_init();
	string m_Filename;
};




class TAction_VolumeSegmentation
{
public:
	void selectCriticalPointFromJunctionField();
	void selectCriticalPointsFromSelection();
	void segment();

protected:
	vector<TCoord3> m_CriticalPoints;
	bool m_SegmentAll;
};

class TAction_VolumeSegmentationFinestScale : public TAction_VolumeSegmentation, public TAction
{
public:
	virtual string getName() { return "Segment at finest scale"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_VolumeSegmentationAllScales : public TAction_VolumeSegmentation, public TAction
{
public:
	virtual string getName() { return "Segment at all scales"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TCriticalPointInfo
{
public:
	TCriticalPointInfo() {};
	TCriticalPointInfo(unsigned int p_Index, bool p_Valid, bool p_Default, float p_Collapse, float p_PathStartRadius, unsigned int p_JunctionIndex, unsigned int p_PathStartIndex)
		: m_Index(p_Index)
		, m_Valid(p_Valid)
		, m_Collapse(p_Collapse)
		, m_Default(p_Default)
		, m_PathStartRadius(p_PathStartRadius)
		, m_JunctionIndex( p_JunctionIndex)
		, m_PathStartIndex( p_PathStartIndex )
	{
	};
	unsigned int m_Index;
	unsigned int m_JunctionIndex;
	unsigned int m_PathStartIndex;
	bool m_Valid;
	bool m_Default;
	float m_Collapse;
	float m_Rho;
	float m_RelativeRho;
	float m_Radius;
	float m_RelativeRadius;
	float m_PathStartRadius;
};

class TAction_VolumeSegmentationFlat : public TAction_VolumeSegmentation, public TAction
{
public:
	TAction_VolumeSegmentationFlat();
	static string getStaticName() { return "Flat segmentation"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	bool m_FillZeros;
	string m_Name;
	float m_DilationDistance;
	bool m_ForceTwoComponentsPerCp;
	bool m_MakeMinColor;
	float m_RemoveSmallComponents;
	std::set<TCoord3> m_ForceTwoComponentsPerCpExceptThese;

	TTypedFieldInterface<unsigned int>* m_Output;
	vector<std::set<unsigned int> > m_Sizes;
protected:
	virtual void perform_main();
};


class TAction_VolumeSegmentationFlat2 : public TAction_VolumeSegmentationFlat
{
public:
	TAction_VolumeSegmentationFlat2();
	virtual void perform_main();
	virtual string getName() { return "Flat segmentation min-color"; }
	virtual string getHelpString() { return ""; }
	unsigned int m_OutputSegmentCount;
protected:
};

class TAction_VolumeSegmentationFinestScaleUsingSelectedCp : public TAction_VolumeSegmentation, public TAction
{
public:
	virtual string getName() { return "Segment at finest scale using selected critical point"; }
	virtual string getHelpString() { return "Use the user selection of the current layer as critical points"; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



class TAction_CurveSkeletonFeatureAngle : public TAction
{
public:
	static string getStaticName() { return "Compute geodesicness measure"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	static float computeGeodesicness(const TCoord3 p, const class TIndexedOrigins_Vector * p_Path, const class TIndexedOrigins_Vector * p_Eft, TTypedFieldInterface<unsigned int> * p_Debug = 0);
	
protected:
	virtual void perform_main();
};

class TAction_ComputeComponentSets : public TAction
{
public:
	static string getStaticName() { return "Compute component sets"; }
	
	virtual string getName() { return getStaticName(); }
	virtual string getScreenName() { return getName(); }
	
	virtual string getHelpString() { return "Computes the component sets on the curve skeleton by using shortest-path sets"; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_SetRobustComponentTau : public TAction
{
public:
	virtual string getName() { return "Set robust component tau"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_SetSegmSigmaThreshold : public TAction
{
public:
	virtual string getName() { return "Set minimum geodesicness (sigma)"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_SetSegmRhoSimilar : public TAction
{
public:
	virtual string getName() { return "Set body/limb rho similarity"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



class TAction_MoveCriticalPoints : public TAction
{
public:
	virtual string getName() { return "Branch-critical segmentation"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	static double gauss_d2(double x, double s);
protected:
	virtual void perform_main();
	void findShortestPathOnCskel(unsigned int p_Start, unsigned int p_End, TIndexedOrigins_Vector * p_Result);
};

class TAction_MergeJunctions : public TAction
{
public:
	virtual string getName() { return "Merge junctions"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	static void updateComponentSets(TTypedFieldInterface<unsigned char> * Junctions);
protected:
	virtual void perform_main();
};



class TAction_NewJunctionDetection : public TAction
{
public:
	static string getStaticName() { return "New junction detection"; }
	
	virtual string getName() { return getStaticName(); }
	virtual string getScreenName() { return getStaticName(); }
	
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



class TAction_CleanupCriticalPoints : public TAction
{
public:
	virtual string getName() { return "Cleanup critical points"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_MoveCriticalPoints2 : public TAction
{
public:
	virtual string getName() { return "Move critical points 2"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_VolumeSegmentationLigatures : public TAction_VolumeSegmentationFlat
{
public:
	TAction_VolumeSegmentationLigatures();
	virtual void perform_main();
	virtual string getName() { return "Segmentation by ligatures"; }
	virtual string getHelpString() { return ""; }
protected:
};


class TAction_VolumeSegmentationMapToMesh : public TAction_VolumeSegmentationFlat
{
public:
	TAction_VolumeSegmentationMapToMesh();
	virtual void perform_main();
	virtual string getName() { return "Map to mesh"; }
	virtual string getHelpString() { return ""; }
protected:
};


#endif




