/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_CALL_GRAPH_EDGE_H
#define CCC_CALL_GRAPH_EDGE_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include <libcci/cci.h>
#include <sstream>


// ----------------------------------------------------------------------------
// Class declarations
// ----------------------------------------------------------------------------
class GraphNode;
class FunctionGraphNode;


// ----------------------------------------------------------------------------
// Enums
// ----------------------------------------------------------------------------
enum GraphEdgeType
{
	GET_Contains,
	GET_Calls
};

enum CallViaPointer
{
	CVP_No,
	CVP_PointerToFunction,
	CVP_PointerToMember
};

enum CallOnObject
{
	COO_No,
	COO_ObjectInstance,
	COO_ObjectReference,
	COO_ObjectPointer
};


// ----------------------------------------------------------------------------
// Class GraphEdge
// ----------------------------------------------------------------------------
class GraphEdge
{
protected:
	GraphEdge(GraphNode* pSrcNode, GraphNode* pDstNode);

public:
	virtual ~GraphEdge();

public:
	virtual GraphEdgeType GetType() = 0;
	int GetId();
	GraphNode* GetSourceNode();
	GraphNode* GetDestinationNode();

private:
	int        m_iId;
	GraphNode* m_pSrcNode;
	GraphNode* m_pDstNode;
	static int m_iNextFreeId;;
};


// ----------------------------------------------------------------------------
// Class ContainsGraphEdge
// ----------------------------------------------------------------------------
class ContainsGraphEdge : public GraphEdge
{
public:
	ContainsGraphEdge(GraphNode* pSrcNode, GraphNode* pDstNode);

public:
	virtual GraphEdgeType GetType();
};


// ----------------------------------------------------------------------------
// Class CallsGraphEdge
// ----------------------------------------------------------------------------
class CallsGraphEdge : public GraphEdge
{
public:
	CallsGraphEdge(FunctionGraphNode* pSrcNode, FunctionGraphNode* pDstNode, CCI_FunctionCall* pFunctionCall, int iCallCandidateSetSize, int iCallCandidateSetId);

public:
	virtual GraphEdgeType GetType();
	std::string GetCallFile();
	std::string GetCallPosition();

	bool IsCallVirtual();
	bool IsCallAccurate();
	int GetCallCandidateSetId();
	CallViaPointer GetCallViaPointer();
	CallOnObject GetCallOnObject();

private:
	CCI_FunctionCall* m_pFunctionCall;
	int m_iCallCandidateSetSize;
	int m_iCallCandidateSetId;
};


#endif
