/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_CALL_GRAPH_NODE_H
#define CCC_CALL_GRAPH_NODE_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include <libcci/cci.h>
#include <sstream>


// ----------------------------------------------------------------------------
// Enums
// ----------------------------------------------------------------------------
enum GraphNodeType
{
	GNT_Directory,
	GNT_File,
	GNT_Class,
	GNT_Function
};

enum AccessSpecifier
{
	AS_None,
	AS_Public,
	AS_Protected,
	AS_Private
};


// ----------------------------------------------------------------------------
// Class GraphNode
// ----------------------------------------------------------------------------
class GraphNode
{
protected:
	GraphNode(std::string szName);

public:
	virtual ~GraphNode();

public:
	virtual GraphNodeType GetType() = 0;
	int GetId();
	std::string GetName();

private:
	int         m_iId;
	std::string m_szName;
	static int m_iNextFreeId;
};


// ----------------------------------------------------------------------------
// Class DirectoryGraphNode
// ----------------------------------------------------------------------------
class DirectoryGraphNode : public GraphNode
{
public:
	DirectoryGraphNode(std::string szName);

public:
	virtual GraphNodeType GetType();
};


// ----------------------------------------------------------------------------
// Class FileGraphNode
// ----------------------------------------------------------------------------
class FileGraphNode : public GraphNode
{
public:
	FileGraphNode(CCI_SourceLoc* pSourceLoc, std::string szName);

public:
	virtual GraphNodeType GetType();
	std::string GetFileName();
	std::string GetFilePath();
	
private:
	CCI_SourceLoc* m_pSourceLoc;
};

// ----------------------------------------------------------------------------
// Class ClassGraphNode
// ----------------------------------------------------------------------------
class ClassGraphNode : public GraphNode
{
public:
	ClassGraphNode(std::string szName);

public:
	virtual GraphNodeType GetType();
};


// ----------------------------------------------------------------------------
// Class FunctionGraphNode
// ----------------------------------------------------------------------------
class FunctionGraphNode : public GraphNode
{
public:
	FunctionGraphNode(CCI_LocalFunction* pLocalFunction);

public:
	virtual GraphNodeType GetType();
	std::string GetSignature();
	std::string GetClassName();
	std::string GetDeclarationFileName();
	std::string GetDeclarationPosition();
	std::string GetDefinitionFileName();
	std::string GetDefinitionPosition();
	bool HasClassName();
	bool HasDefinitionFileName();
	bool HasDefinitionPosition();
	bool IsMethod();
	bool IsVirtual();
	bool IsStatic();
	bool IsStaticLinkage();
	bool IsInline();
	AccessSpecifier GetAccessSpecifier();

private:
	CCI_LocalFunction* m_pLocalFunction;
};


#endif
