/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_call_graph_printer.h"
#include "ccc_call_graph.h"
#include "ccc_settings.h"
#include <sstream>


// ----------------------------------------------------------------------------
// Construction
// ----------------------------------------------------------------------------
CCC_CallGraphPrinter::CCC_CallGraphPrinter(std::string szFileName) : m_os(szFileName.length() == 0 ? std::cout : m_ofs)
{
	m_bUseFileStream = szFileName.length() > 0;
	m_szFileName     = szFileName;
}


// ----------------------------------------------------------------------------
// Output stream
// ----------------------------------------------------------------------------
std::ios::openmode CCC_CallGraphPrinter::GetStreamOpenMode()
{
	return std::ios::out | std::ios::trunc;;
}


// ----------------------------------------------------------------------------
// Printing
// ----------------------------------------------------------------------------
void CCC_CallGraphPrinter::Print(CCC_CallGraph* pCallGraph)
{
	cci_assert(pCallGraph != NULL);
	m_pCallGraph = pCallGraph;

	if(m_bUseFileStream)
	{
		m_ofs.open(m_szFileName.c_str(), GetStreamOpenMode());
		if(!m_ofs.is_open())
		{
			std::cerr << "Error opening file '" << m_szFileName << "' for writing." << std::endl;
			return;
		}
	}

	PrintGraph();

	if(m_bUseFileStream)
	{
		if(m_ofs.is_open())
			m_ofs.close();
	}
}


// ----------------------------------------------------------------------------
// Helpers
// ----------------------------------------------------------------------------
std::string CCC_CallGraphPrinter::BoolToString(bool b)
{
	return b ? "true" : "false";
}

std::string CCC_CallGraphPrinter::IntToString(int i)
{
	std::stringstream ss;
	ss << i;
	return ss.str();
}
