/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_CALL_GRAPH_PRINTER_H
#define CCC_CALL_GRAPH_PRINTER_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include <libcci/cci.h>
#include <fstream>


// ----------------------------------------------------------------------------
// Class declarations
// ----------------------------------------------------------------------------
class CCC_CallGraph;


// ----------------------------------------------------------------------------
// Class CCC_CallGraphPrinter
// ----------------------------------------------------------------------------
class CCC_CallGraphPrinter
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	// Pass an empty string to print to stdout.
	CCC_CallGraphPrinter(std::string szFileName);


	// ------------------------------------------------------------------------
	// Output stream
	// ------------------------------------------------------------------------
protected:
	virtual std::ios::openmode GetStreamOpenMode();


	// ------------------------------------------------------------------------
	// Printing
	// ------------------------------------------------------------------------
public:
	void Print(CCC_CallGraph* pCallGraph);

protected:
	virtual void PrintGraph() = 0;


	// ------------------------------------------------------------------------
	// Helpers
	// ------------------------------------------------------------------------
public:
	std::string BoolToString(bool b);
	std::string IntToString(int i);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
protected:
	CCC_CallGraph* m_pCallGraph;

protected:
	std::string m_szFileName;
	std::ostream & m_os;

private:
	std::ofstream m_ofs;
	bool m_bUseFileStream;
};


#endif
